/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class ConjugateGradientNormalErrorSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int H;

    public ConjugateGradientNormalErrorSolver() {
        this(50);
    }

    private Vector H(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        Matrix a9 = a2.t();
        Vector a10 = a6;
        Vector a11 = a3.minus(a2.multiply(a10));
        Vector a12 = a10.ZERO();
        double a13 = 1.0;
        int a14 = 1;
        boolean a15 = false;
        a15 = a5.updateResidualNorm(a11.norm());
        int n = a14;
        int n2 = a4;
        while (n <= n2 && !a15) {
            ConjugateGradientNormalErrorSolver a16;
            a8.addIterate(a10);
            Vector a17 = a7.solve(a11);
            double a18 = a17.innerProduct(a11);
            if (Double.compare(a18, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("(o;4b+3)<e"));
            }
            double a19 = a18 / a13;
            a12 = a9.multiply(a17).add(a12.scaled(a19));
            Vector a20 = a2.multiply(a12);
            double a21 = a12.innerProduct(a12);
            if (Double.compare(a21, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("(e;4`+3)<e"));
            }
            double a22 = a18 / a21;
            a10 = a10.add(a12.scaled(a22));
            a11 = a14 % a16.H != 0 ? a11.minus(a20.scaled(a22)) : a3.minus(a2.multiply(a10));
            a13 = a18;
            a15 = a5.updateResidualNorm(a11.norm());
            n = ++a14;
            n2 = a4;
        }
        a8.addIterate(a10);
        if (!a15) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS);
        }
        return a10;
    }

    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.H(problem.A(), problem.b(), Math.min(problem.maxIteration(), problem.A().nCols()), problem.tolerance(), problem.initialGuess(), problem.leftPreconditioner(), monitor);
    }

    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    public ConjugateGradientNormalErrorSolver(int residualRefreshRate) {
        this.H = residualRefreshRate;
    }
}

