/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class ConjugateGradientNormalResidualSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int H;

    public ConjugateGradientNormalResidualSolver() {
        this(50);
    }

    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    private Vector H(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        Matrix a9 = a2.t();
        Vector a10 = a6;
        Vector a11 = a3.minus(a2.multiply(a10));
        Vector a12 = a10.ZERO();
        double a13 = 1.0;
        int a14 = 1;
        boolean a15 = false;
        a15 = a5.updateResidualNorm(a11.norm());
        int n = a14;
        int n2 = a4;
        while (n <= n2 && !a15) {
            ConjugateGradientNormalResidualSolver a16;
            a8.addIterate(a10);
            Vector a17 = a9.multiply(a11);
            Vector a18 = a7.solve(a17);
            double a19 = a18.innerProduct(a17);
            if (Double.compare(a19, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("&a5:lOtvv~/:+;e"));
            }
            double a20 = a19 / a13;
            Vector a21 = a2.multiply(a12 = a18.add(a12.scaled(a20)));
            double a22 = a21.innerProduct(a21);
            if (Double.compare(a22, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("(b;4g+3)<e"));
            }
            double a23 = a19 / a22;
            a10 = a10.add(a12.scaled(a23));
            a11 = a14 % a16.H != 0 ? a11.minus(a21.scaled(a23)) : a3.minus(a2.multiply(a10));
            a13 = a19;
            a15 = a5.updateResidualNorm(a11.norm());
            n = ++a14;
            n2 = a4;
        }
        a8.addIterate(a10);
        if (!a15) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS);
        }
        return a10;
    }

    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.H(problem.A(), problem.b(), Math.min(problem.maxIteration(), problem.A().nCols()), problem.tolerance(), problem.initialGuess(), problem.leftPreconditioner(), monitor);
    }

    public ConjugateGradientNormalResidualSolver(int residualRefreshRate) {
        this.H = residualRefreshRate;
    }
}

