/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class ConjugateGradientSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int H;

    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    public ConjugateGradientSolver() {
        this(50);
    }

    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.H(problem.A(), problem.b(), Math.min(problem.maxIteration(), problem.A().nCols()), problem.tolerance(), problem.initialGuess(), problem.leftPreconditioner(), monitor);
    }

    private Vector H(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        Vector a9 = a6;
        Vector a10 = a3.minus(a2.multiply(a9));
        Vector a11 = a9.ZERO();
        double a12 = 1.0;
        int a13 = 1;
        boolean a14 = false;
        a14 = a5.updateResidualNorm(a10.norm());
        int n = a13;
        int n2 = a4;
        while (n <= n2 && !a14) {
            ConjugateGradientSolver a15;
            Vector a16;
            a8.addIterate(a9);
            Vector a17 = a7.solve(a10);
            double a18 = a10.innerProduct(a17);
            if (Double.compare(a18, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("(g;4j+3)<e"));
            }
            double a19 = a18 / a12;
            double a20 = (a11 = a17.add(a11.scaled(a19))).innerProduct(a16 = a2.multiply(a11));
            if (Double.compare(a20, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("(e;4a+3)<e"));
            }
            double a21 = a18 / a20;
            a9 = a9.add(a11.scaled(a21));
            a10 = a13 % a15.H != 0 ? a10.minus(a16.scaled(a21)) : a3.minus(a2.multiply(a9));
            a12 = a18;
            a14 = a5.updateResidualNorm(a10.norm());
            n = ++a13;
            n2 = a4;
        }
        a8.addIterate(a9);
        if (!a14) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS);
        }
        return a9;
    }

    public ConjugateGradientSolver(int residualRefreshRate) {
        this.H = residualRefreshRate;
    }
}

