/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class ConjugateGradientSquaredSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int H;

    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.H(problem.A(), problem.b(), Math.min(problem.maxIteration(), problem.A().nCols()), problem.tolerance(), problem.initialGuess(), problem.leftPreconditioner(), monitor);
    }

    public ConjugateGradientSquaredSolver(int residualRefreshRate) {
        this.H = residualRefreshRate;
    }

    private Vector H(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        Vector a9 = a6;
        Vector a10 = a3.minus(a2.multiply(a9));
        Vector a11 = a10.deepCopy();
        Vector a12 = a9.ZERO();
        Vector a13 = a9.ZERO();
        double a14 = a10.innerProduct(a11);
        int a15 = 1;
        boolean a16 = false;
        a16 = a5.updateResidualNorm(a10.norm());
        int n = a15;
        int n2 = a4;
        while (n <= n2 && !a16) {
            ConjugateGradientSquaredSolver a17;
            a8.addIterate(a9);
            double a18 = a10.innerProduct(a11);
            if (Double.compare(a18, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("&i5:lOtvv~/:+;e"));
            }
            double a19 = a18 / a14;
            Vector a20 = a10.add(a13.scaled(a19));
            a12 = a20.add(a13.add(a12.scaled(a19)).scaled(a19));
            Vector a21 = a7.solve(a12);
            Vector a22 = a2.multiply(a21);
            double a23 = a22.innerProduct(a11);
            if (Double.compare(a23, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("(c_ud93fH|sp}+;)$e"));
            }
            double a24 = a18 / a23;
            a13 = a20.minus(a22.scaled(a24));
            Vector a25 = a20.add(a13);
            Vector a26 = a7.solve(a25);
            a9 = a9.add(a26.scaled(a24));
            Vector a27 = a2.multiply(a26);
            a10 = a15 % a17.H != 0 ? a10.minus(a27.scaled(a24)) : a3.minus(a2.multiply(a9));
            a14 = a18;
            a16 = a5.updateResidualNorm(a10.norm());
            n = ++a15;
            n2 = a4;
        }
        a8.addIterate(a9);
        if (!a16) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS);
        }
        return a9;
    }

    public ConjugateGradientSquaredSolver() {
        this(50);
    }

    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }
}

