/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class GeneralizedConjugateResidualSolver
implements IterativeSolver {
    private final int H;

    public GeneralizedConjugateResidualSolver(int m) {
        this.H = m;
    }

    public GeneralizedConjugateResidualSolver() {
        this.H = Integer.MAX_VALUE;
    }

    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.H(problem.A(), problem.b(), this.H >= problem.A().nCols() ? Math.min(problem.maxIteration(), problem.A().nCols()) : problem.maxIteration(), problem.tolerance(), problem.initialGuess(), problem.leftPreconditioner(), monitor);
    }

    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    private Vector H(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        GeneralizedConjugateResidualSolver a9;
        int a10 = Math.min(a9.H, a2.nCols());
        Vector a11 = a6;
        Vector a12 = a3.minus(a2.multiply(a11));
        int a13 = 1;
        boolean a14 = false;
        a14 = a5.updateResidualNorm(a12.norm());
        int n = a13;
        int n2 = a4;
        while (n <= n2 && !a14) {
            int a15;
            Vector a16 = a7.solve(a12);
            Vector[] a17 = new Vector[a10 + 1];
            Vector[] a18 = new Vector[a10];
            double[] a19 = new double[a10];
            a17[0] = a16.scaled(1.0 / a16.norm());
            int n3 = a15 = 1;
            int n4 = a10;
            while (n3 <= n4 && a13 <= a4 && !a14) {
                int a20;
                a8.addIterate(a11);
                Vector a21 = a2.multiply(a17[a15 - 1]);
                a18[a15 - 1] = a7.solve(a21);
                a19[a15 - 1] = a18[a15 - 1].innerProduct(a18[a15 - 1]);
                if (Double.compare(a19[a15 - 1], 0.0) == 0) {
                    throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("(b;4g+3)<e"));
                }
                double a22 = a12.innerProduct(a18[a15 - 1]) / a19[a15 - 1];
                a11 = a11.add(a17[a15 - 1].scaled(a22));
                a12 = a12.minus(a18[a15 - 1].scaled(a22));
                Vector a23 = a2.multiply(a12);
                Vector a24 = a7.solve(a23);
                a17[a15] = a12;
                int n5 = a20 = 0;
                while (n5 < a15) {
                    double a25 = -a24.innerProduct(a18[a20]) / a19[a20];
                    a17[a15] = a17[a15].add(a17[a20].scaled(a25));
                    n5 = ++a20;
                }
                ++a13;
                a14 = a5.updateResidualNorm(a12.norm());
                n3 = ++a15;
                n4 = a10;
            }
            a12 = a3.minus(a2.multiply(a11));
            a14 = a5.updateResidualNorm(a12.norm());
            n = a13;
            n2 = a4;
        }
        a8.addIterate(a11);
        if (!a14) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS);
        }
        return a11;
    }
}

