/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.DeepCopyable;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.BackwardSubstitution;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.GivensMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.SubMatrixRef;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;
import java.util.Arrays;

public class GeneralizedMinimalResidualSolver
implements IterativeSolver {
    private final int H;

    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    public GeneralizedMinimalResidualSolver() {
        this.H = Integer.MAX_VALUE;
    }

    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.H(problem.A(), problem.b(), this.H >= problem.A().nCols() ? Math.min(problem.maxIteration(), problem.A().nCols()) : problem.maxIteration(), problem.tolerance(), problem.initialGuess(), problem.leftPreconditioner(), monitor);
    }

    private Vector H(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        GeneralizedMinimalResidualSolver a9;
        int a10 = Math.min(a9.H, a2.nCols());
        Vector[] a11 = new Vector[a10 + 1];
        Object a12 = new DenseMatrix(a10 + 1, a10).ZERO();
        Vector a13 = a6;
        Vector a14 = a3.minus(a2.multiply(a13));
        a14 = a7.solve(a14);
        double a15 = a14.norm();
        GivensMatrix[] a16 = new GivensMatrix[a10];
        int a17 = 1;
        boolean a18 = false;
        a18 = a5.updateResidualNorm(a15);
        int n = a17;
        int n2 = a4;
        while (n <= n2 && !a18) {
            DeepCopyable a19;
            Vector a20;
            int a21;
            a11[0] = a14.scaled(1.0 / a15);
            Vector a22 = new DenseVector(a10 + 1, 0.0);
            a22.set(1, a15);
            int n3 = a21 = 1;
            int n4 = a10;
            while (n3 <= n4 && a17 <= a4 && !a18) {
                int a23;
                int a24;
                a8.addIterate(a13);
                a20 = a2.multiply(a11[a21 - 1]);
                a20 = a7.solve(a20);
                a19 = new DenseVector(a10 + 1, 0.0);
                int n5 = a24 = 1;
                while (n5 <= a21) {
                    double a25 = a20.innerProduct(a11[a24 - 1]);
                    a19.set(a24, a25);
                    a20 = a20.minus(a11[a24 - 1].scaled(a25));
                    n5 = ++a24;
                }
                double a25 = a20.norm();
                a19.set(a21 + 1, a25);
                if (Double.compare(a25, 0.0) != 0) {
                    a11[a21] = a20.scaled(1.0 / a25);
                }
                int n6 = a23 = 1;
                while (true) {
                    if (n6 > a21 - 1) break;
                    a19 = a16[a23 - 1].multiply((Vector)a19);
                    n6 = ++a23;
                }
                a16[a21 - 1] = GivensMatrix.CtorToRotateRows(a10 + 1, a21, a21 + 1, a19.get(a21), a19.get(a21 + 1));
                a22 = a16[a21 - 1].multiply(a22);
                a19 = a16[a21 - 1].multiply((Vector)a19);
                int n7 = a23 = 1;
                while (n7 <= a21) {
                    a12.set(a23, a21, a19.get(a23));
                    n7 = ++a23;
                }
                a15 = Math.abs(a22.get(a21 + 1));
                ++a17;
                a18 = a5.updateResidualNorm(a15);
                n3 = ++a21;
                n4 = a10;
            }
            a20 = CreateVector.subVector(a22, 1, --a21);
            a19 = new UpperTriangularMatrix(new SubMatrixRef((Matrix)a12, 1, a21, 1, a21));
            Vector a26 = new BackwardSubstitution((UpperTriangularMatrix)a19).solve(a20);
            a13 = a13.add(CreateMatrix.cbind(Arrays.copyOf(a11, a21)).multiply(a26));
            a14 = a3.minus(a2.multiply(a13));
            a14 = a7.solve(a14);
            a15 = a14.norm();
            a18 = a5.updateResidualNorm(a15);
            n = a17;
            n2 = a4;
        }
        a8.addIterate(a13);
        if (!a18) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS);
        }
        return a13;
    }

    public GeneralizedMinimalResidualSolver(int m) {
        this.H = m;
    }
}

