/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.GivensMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class QuasiMinimalResidualSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int H;

    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.H(problem.A(), problem.b(), Math.min(problem.maxIteration(), problem.A().nCols()), problem.tolerance(), problem.initialGuess(), problem.leftPreconditioner(), problem.rightPreconditioner(), monitor);
    }

    private Vector H(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, Preconditioner a8, IterationMonitor a9) throws IterativeSolver.ConvergenceFailure {
        Matrix a10 = a2.t();
        Vector a11 = a6;
        Vector a12 = a3.minus(a2.multiply(a11));
        Vector a13 = a12.deepCopy();
        Vector a14 = a7.solve(a13);
        double a15 = a14.norm();
        Vector a16 = a12.deepCopy();
        Vector a17 = a8.transposeSolve(a16);
        double a18 = a17.norm();
        Vector a19 = a12.ZERO();
        Vector a20 = a12.ZERO();
        Vector a21 = a11.ZERO();
        Vector a22 = a12.ZERO();
        double a23 = 1.0;
        double a24 = -1.0;
        double a25 = 1.0;
        double a26 = 0.0;
        int a27 = 1;
        boolean a28 = false;
        a28 = a5.updateResidualNorm(a12.norm());
        int n = a27;
        int n2 = a4;
        while (n <= n2 && !a28) {
            QuasiMinimalResidualSolver a29;
            Vector a30;
            a9.addIterate(a11);
            if (Double.compare(a15, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("`{~2+3e"));
            }
            if (Double.compare(a18, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("l|7)0e"));
            }
            Vector a31 = a13.scaled(1.0 / a15);
            a14 = a14.scaled(1.0 / a15);
            Vector a32 = a16.scaled(1.0 / a18);
            double a33 = (a17 = a17.scaled(1.0 / a18)).innerProduct(a14);
            if (Double.compare(a33, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("yyrix<'=e"));
            }
            Vector a34 = a8.solve(a14);
            Vector a35 = a7.transposeSolve(a17);
            a19 = a34.minus(a19.scaled(a18 * a33 / a25));
            if (Double.compare(a25 = (a20 = a35.minus(a20.scaled(a15 * a33 / a25))).innerProduct(a30 = a2.multiply(a19)), 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("{onwvpw>+?e"));
            }
            double a36 = a25 / a33;
            if (Double.compare(a36, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("wqbt1)2e"));
            }
            a13 = a30.minus(a31.scaled(a36));
            a14 = a7.solve(a13);
            double a37 = a14.norm();
            a16 = a10.multiply(a20).minus(a32.scaled(a36));
            a17 = a8.transposeSolve(a16);
            a18 = a17.norm();
            double a38 = a37 / (a23 * Math.abs(a36));
            double a39 = 1.0 / Math.sqrt(1.0 + a38 * a38);
            if (Double.compare(a39, 0.0) == 0) {
                throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.BREAKDOWN, b.C("z}spx<'=e"));
            }
            a24 = -a24 * a15 * a39 * a39 / (a36 * a23 * a23);
            double a40 = a26 * a39;
            a40 *= a40;
            a21 = a19.scaled(a24).add(a21.scaled(a40));
            a22 = a30.scaled(a24).add(a22.scaled(a40));
            a11 = a11.add(a21);
            a12 = a27 % a29.H != 0 ? a12.minus(a22) : a3.minus(a2.multiply(a11));
            a15 = a37;
            a26 = a38;
            a23 = a39;
            a28 = a5.updateResidualNorm(a12.norm());
            n = ++a27;
            n2 = a4;
        }
        a9.addIterate(a11);
        if (!a28) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS);
        }
        return a11;
    }

    public QuasiMinimalResidualSolver(int residualRefreshRate) {
        this.H = residualRefreshRate;
    }

    private Vector H(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, IterationMonitor a7) throws IterativeSolver.ConvergenceFailure {
        Matrix a8 = a2.t();
        Vector a9 = a6;
        Vector a10 = a3.minus(a2.multiply(a9));
        Vector a11 = a10.deepCopy();
        double a12 = a10.norm();
        Vector a13 = a10.scaled(1.0 / a12);
        Vector a14 = a11.scaled(1.0 / a11.innerProduct(a13));
        double a15 = 0.0;
        double a16 = 0.0;
        Vector a17 = a13.ZERO();
        Vector a18 = a14.ZERO();
        GivensMatrix a19 = GivensMatrix.Ctor2x2(1.0, 0.0);
        GivensMatrix a20 = GivensMatrix.Ctor2x2(1.0, 0.0);
        Vector a21 = a14.ZERO();
        Vector a22 = a14.ZERO();
        double a23 = 0.0;
        double a24 = 1.0;
        int a25 = 1;
        boolean a26 = false;
        a26 = a5.updateResidualNorm(a10.norm());
        int n = a25;
        int n2 = a4;
        while (n <= n2 && !a26) {
            a7.addIterate(a9);
            Vector a27 = a2.multiply(a13);
            Vector a28 = a8.multiply(a14);
            double a29 = a27.innerProduct(a14);
            Vector a30 = a27.minus(a13.scaled(a29)).minus(a17.scaled(a15));
            double a31 = a29;
            Vector a32 = a28.minus(a14.scaled(a31)).minus(a18.scaled(a16));
            double a33 = a30.norm();
            Vector a34 = a30.scaled(1.0 / a33);
            double a35 = a34.innerProduct(a32);
            Vector a36 = a32.scaled(1.0 / a35);
            double a37 = a29;
            double a38 = a35;
            double a39 = a33;
            double[] dArray = new double[2];
            dArray[0] = 0.0;
            dArray[1] = a23;
            Vector a40 = new DenseVector(dArray);
            a40 = a20.multiply(a40);
            double[] dArray2 = new double[2];
            dArray2[0] = a40.get(2);
            dArray2[1] = a37;
            Vector a41 = new DenseVector(dArray2);
            a41 = a19.multiply(a41);
            GivensMatrix a42 = GivensMatrix.CtorToRotateRows(2, 1, 2, a41.get(2), a39);
            double[] dArray3 = new double[2];
            dArray3[0] = a24;
            dArray3[1] = 0.0;
            Vector a43 = new DenseVector(dArray3);
            a43 = a42.multiply(a43);
            double a44 = a43.get(2);
            double[] dArray4 = new double[2];
            dArray4[0] = a41.get(2);
            dArray4[1] = a39;
            Vector a45 = new DenseVector(dArray4);
            a45 = a42.multiply(a45);
            Vector a46 = a13.minus(a22.scaled(a41.get(1))).minus(a21.scaled(a40.get(1))).scaled(1.0 / a45.get(1));
            double a47 = a12 * a43.get(1);
            a9 = a9.add(a46.scaled(a47));
            a10 = a3.minus(a2.multiply(a9));
            a23 = a38;
            a21 = a22;
            a22 = a46;
            a17 = a13;
            a13 = a34;
            a18 = a14;
            a14 = a36;
            a15 = a35;
            a16 = a33;
            a20 = a19;
            a19 = a42;
            a24 = a44;
            a26 = a5.updateResidualNorm(a10.norm());
            n = ++a25;
            n2 = a4;
        }
        a7.addIterate(a9);
        if (!a26) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS);
        }
        return a9;
    }

    public QuasiMinimalResidualSolver() {
        this(50);
    }

    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }
}

