/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class SteepestDescentSolver
implements IterativeSolver {
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int H;

    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.H(problem.A(), problem.b(), problem.maxIteration(), problem.tolerance(), problem.initialGuess(), problem.leftPreconditioner(), monitor);
    }

    public SteepestDescentSolver(int residualRefreshRate) {
        this.H = residualRefreshRate;
    }

    private Vector H(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, Preconditioner a7, IterationMonitor a8) throws IterativeSolver.ConvergenceFailure {
        Vector a9 = a6;
        Vector a10 = a3.minus(a2.multiply(a9));
        int a11 = 1;
        boolean a12 = false;
        a12 = a5.updateResidualNorm(a10.norm());
        int n = a11;
        int n2 = a4;
        while (n <= n2 && !a12) {
            SteepestDescentSolver a13;
            a8.addIterate(a9);
            Vector a14 = a7.solve(a10);
            Vector a15 = a2.multiply(a14);
            double a16 = a10.innerProduct(a14) / a15.innerProduct(a14);
            a9 = a9.add(a14.scaled(a16));
            a10 = a11 % a13.H != 0 ? a10.minus(a15.scaled(a16)) : a3.minus(a2.multiply(a9));
            a12 = a5.updateResidualNorm(a10.norm());
            n = ++a11;
            n2 = a4;
        }
        a8.addIterate(a9);
        if (!a12) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS);
        }
        return a9;
    }

    public SteepestDescentSolver() {
        this(50);
    }

    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }
}

