/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner;

import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class JacobiPreconditioner
implements Preconditioner {
    private final Vector H;

    public Vector solve(Vector x2) {
        return x2.multiply(this.H);
    }

    public JacobiPreconditioner(Matrix A) {
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), b.C("L,cxzx*o`,g-r}wloi>`xxhd-"));
        Vector a2 = CreateVector.diagonal(A);
        this.H = CreateVector.foreach(a2, new UnivariateRealFunction(){
            {
                1 a2;
            }

            public double evaluate(double x2) {
                return 1.0 / x2;
            }
        });
    }

    public Vector transposeSolve(Vector x2) {
        return this.solve(x2);
    }
}

