/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.stationary;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class JacobiSolver
implements IterativeSolver {
    private Vector H(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, IterationMonitor a7) throws IterativeSolver.ConvergenceFailure {
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(a2), b.C("zgh.gn}|ow%O\"bt}j/\u007fk:|h{w}0"));
        JacobiSolver.H(a2);
        int a8 = a2.nCols();
        Vector a9 = a6;
        Vector a10 = a3.minus(a2.multiply(a9));
        int a11 = 1;
        boolean a12 = false;
        a12 = a5.updateResidualNorm(a10.norm());
        int n = a11;
        int n2 = a4;
        while (n <= n2 && !a12) {
            int a13;
            a7.addIterate(a9);
            Vector a14 = new DenseVector(a8).ZERO();
            int n3 = a13 = 1;
            while (n3 <= a8) {
                int a15;
                double a16 = 0.0;
                int n4 = a15 = 1;
                while (n4 <= a8) {
                    if (a15 != a13) {
                        a16 += a2.get(a13, a15) * a9.get(a15);
                    }
                    n4 = ++a15;
                }
                a16 = (a3.get(a13) - a16) / a2.get(a13, a13);
                a14.set(a13, a16);
                n3 = ++a13;
            }
            a9 = a14;
            a10 = a3.minus(a2.multiply(a9));
            a12 = a5.updateResidualNorm(a10.norm());
            n = ++a11;
            n2 = a4;
        }
        a7.addIterate(a9);
        if (!a12) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS);
        }
        return a9;
    }

    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }

    private static void H(Matrix a2) {
        int a3;
        int n = a3 = 1;
        while (n <= a2.nCols()) {
            if (Double.compare(a2.get(a3, a3), 0.0) == 0) {
                throw new IllegalArgumentException(b.C("Q]WR^ZSY\u001dQPAK]_F\u0005YSFU\u0014@P\rZA[\u0004NOG:"));
            }
            n = ++a3;
        }
    }

    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.H(problem.A(), problem.b(), problem.maxIteration(), problem.tolerance(), problem.initialGuess(), monitor);
    }
}

