/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.stationary;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class SorSweep {
    private final int G;
    private final Matrix M;
    private final double m;
    private final Vector H;

    public Vector backward(Vector x2) {
        int a2;
        Vector a3 = new DenseVector(this.G).ZERO();
        int n = a2 = this.G;
        while (true) {
            int a4;
            if (n < 1) break;
            double a5 = 0.0;
            int n2 = a4 = 1;
            while (n2 < a2) {
                a5 += this.M.get(a2, a4) * x2.get(a4);
                n2 = ++a4;
            }
            int n3 = a4 = a2 + 1;
            while (n3 <= this.G) {
                a5 += this.M.get(a2, a4) * a3.get(a4);
                n3 = ++a4;
            }
            a5 = (this.H.get(a2) - a5) / this.M.get(a2, a2);
            a5 = x2.get(a2) + this.m * (a5 - x2.get(a2));
            a3.set(a2, a5);
            n = --a2;
        }
        return a3;
    }

    public Vector forward(Vector x2) {
        int a2;
        Vector a3 = new DenseVector(this.G).ZERO();
        int n = a2 = 1;
        while (n <= this.G) {
            int a4;
            double a5 = 0.0;
            int n2 = a4 = 1;
            while (n2 < a2) {
                a5 += this.M.get(a2, a4) * a3.get(a4);
                n2 = ++a4;
            }
            int n3 = a4 = a2 + 1;
            while (n3 <= this.G) {
                a5 += this.M.get(a2, a4) * x2.get(a4);
                n3 = ++a4;
            }
            a5 = (this.H.get(a2) - a5) / this.M.get(a2, a2);
            a5 = x2.get(a2) + this.m * (a5 - x2.get(a2));
            a3.set(a2, a5);
            n = ++a2;
        }
        return a3;
    }

    public SorSweep(Matrix A, Vector b2, double omega) {
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), b.C("L,cxzx*o`,g-r}wloi>`xxhd-"));
        SorSweep.H(A);
        this.M = A;
        this.H = b2;
        this.G = A.nCols();
        this.m = omega;
    }

    private static void H(Matrix a2) {
        int a3;
        int n = a3 = 1;
        while (n <= a2.nCols()) {
            if (Double.compare(a2.get(a3, a3), 0.0) == 0) {
                throw new IllegalArgumentException(b.C("Q]WR^ZSY\u001dQPAK]_F\u0005YSFU\u0014@P\rZA[\u0004NOG:"));
            }
            n = ++a3;
        }
    }
}

