/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.stationary;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterationMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.NullMonitor;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.Tolerance;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.sparse.solver.iterative.stationary.SorSweep;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class SymmetricSuccessiveOverrelaxationSolver
implements IterativeSolver {
    private final double H;

    public Vector solve(IterativeSolver.Problem problem, IterationMonitor monitor) throws IterativeSolver.ConvergenceFailure {
        return this.H(problem.A(), problem.b(), problem.maxIteration(), problem.tolerance(), problem.initialGuess(), monitor);
    }

    public SymmetricSuccessiveOverrelaxationSolver(double omega) {
        this.H = omega;
    }

    private Vector H(Matrix a2, Vector a3, int a4, Tolerance a5, Vector a6, IterationMonitor a7) throws IterativeSolver.ConvergenceFailure {
        SymmetricSuccessiveOverrelaxationSolver a8;
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(a2), b.C("L,cxzx*o`,g-r}wloi>`xxhd-"));
        SorSweep a9 = new SorSweep(a2, a3, a8.H);
        Vector a10 = a6;
        Vector a11 = a3.minus(a2.multiply(a10));
        int a12 = 1;
        boolean a13 = false;
        a13 = a5.updateResidualNorm(a11.norm());
        int n = a12;
        int n2 = a4;
        while (n <= n2 && !a13) {
            a7.addIterate(a10);
            a10 = a9.forward(a10);
            a10 = a9.backward(a10);
            a11 = a3.minus(a2.multiply(a10));
            a13 = a5.updateResidualNorm(a11.norm());
            n = ++a12;
            n2 = a4;
        }
        a7.addIterate(a10);
        if (!a13) {
            throw new IterativeSolver.ConvergenceFailure(IterativeSolver.ConvergenceFailure.Reason.ITERATIONS);
        }
        return a10;
    }

    public Vector solve(IterativeSolver.Problem problem) throws IterativeSolver.ConvergenceFailure {
        return this.solve(problem, new NullMonitor());
    }
}

