/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.operation;

import com.numericalmethod.suanshu.datastructure.list.MatrixList;
import com.numericalmethod.suanshu.datastructure.list.VectorList;
import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class CreateMatrix {
    public static DenseMatrix rows(Matrix A, int begin, int end) {
        return CreateMatrix.rows(A, R.seq(begin, end));
    }

    public static DenseMatrix rbind(Matrix ... matrices) {
        int a2;
        VectorList a3 = new VectorList();
        Matrix[] a4 = matrices;
        int a5 = matrices.length;
        int n = a2 = 0;
        while (n < a5) {
            Matrix a6 = a4[a2];
            if (a6 != null) {
                int a7;
                int n2 = a7 = 1;
                while (n2 <= a6.nRows()) {
                    a3.add(a6.getRow(a7));
                    n2 = ++a7;
                }
            }
            n = ++a2;
        }
        DenseMatrix denseMatrix = CreateMatrix.rbind(a3);
        return denseMatrix;
    }

    private CreateMatrix() {
        CreateMatrix a2;
    }

    public static DenseMatrix columns(Matrix A, int[] cols) {
        return CreateMatrix.subMatrix(A, R.seq(1, A.nRows()), cols);
    }

    public static DenseMatrix rbind(VectorList vectors) {
        int a2;
        int a3 = vectors.size();
        Vector[] a4 = new Vector[a3];
        int n = a2 = 0;
        while (n < a3) {
            a4[a2] = (Vector)vectors.get(a2);
            n = ++a2;
        }
        return CreateMatrix.rbind(a4);
    }

    public static DenseMatrix subMatrix(Matrix A, int rowFrom, int rowTo, int colFrom, int colTo) {
        int a2;
        VectorList a3 = new VectorList();
        int n = a2 = rowFrom;
        while (n <= rowTo) {
            Vector a4 = CreateVector.subVector(A.getRow(a2), colFrom, colTo);
            a3.add(a4);
            n = ++a2;
        }
        return CreateMatrix.rbind(a3);
    }

    public static DenseMatrix columns(Matrix A, int begin, int end) {
        return CreateMatrix.columns(A, R.seq(begin, end));
    }

    public static DenseMatrix cbind(Vector ... vectors) {
        Matrix a2 = CreateMatrix.rbind(vectors);
        a2 = a2.t();
        return a2;
    }

    public static DenseMatrix subMatrix(Matrix A, int[] rows, int[] cols) {
        int a2;
        DenseMatrix a3 = new DenseMatrix(rows.length, cols.length);
        int n = a2 = 0;
        while (n < rows.length) {
            int a4;
            int n2 = a4 = 0;
            while (n2 < cols.length) {
                a3.set(a2 + 1, a4 + 1, A.get(rows[a2], cols[a4]));
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public static DenseMatrix cbind(Matrix ... matrices) {
        int a2;
        VectorList a3 = new VectorList();
        Matrix[] a4 = matrices;
        int a5 = matrices.length;
        int n = a2 = 0;
        while (n < a5) {
            Matrix a6 = a4[a2];
            if (a6 != null) {
                int a7;
                int n2 = a7 = 1;
                while (n2 <= a6.nCols()) {
                    a3.add(a6.getColumn(a7));
                    n2 = ++a7;
                }
            }
            n = ++a2;
        }
        DenseMatrix denseMatrix = CreateMatrix.cbind(a3);
        return denseMatrix;
    }

    public static DenseMatrix cbind(MatrixList matrices) {
        return CreateMatrix.cbind((DenseMatrix[])matrices.toArray());
    }

    public static DenseMatrix cbind(VectorList vectors) {
        return CreateMatrix.cbind(vectors.toArray());
    }

    public static DenseMatrix rows(Matrix A, int[] rows) {
        return CreateMatrix.subMatrix(A, rows, R.seq(1, A.nCols()));
    }

    public static Matrix replace(Matrix toReplace, int rowFrom, int rowTo, int colFrom, int colTo, Matrix replacement) {
        int a2 = rowTo - rowFrom + 1;
        int a3 = colTo - colFrom + 1;
        SuanShuUtils.assertArgument(rowFrom <= rowTo, b.C("oisgnne&|hz&cimoub&"));
        SuanShuUtils.assertArgument(colFrom <= colTo, b.C("}{au||w4\u007fzsau{;}jqnwe&"));
        Object[] objectArray = new Object[1];
        objectArray[0] = a2;
        SuanShuUtils.assertArgument(replacement.nRows() == a2, String.format(b.C("a|s5cqby|w{x|zn5hurghl\"qbq}5g{~5]u@p\u00111V5O{I&"), objectArray));
        Object[] objectArray2 = new Object[1];
        objectArray2[0] = a3;
        SuanShuUtils.assertArgument(replacement.nCols() == a3, String.format(b.C("NS\\\u001aL^MVSXTWSUA\u001aGZ]HGC\r^M^R\u001aHTQ\u001arZo_>\u001ey\u001aqT}O{U&"), objectArray2));
        SuanShuUtils.assertArgument(rowTo <= toReplace.nRows(), b.C("fz`@\u007f5vl\u007fpzpk5o|a5e{u{gu~,"));
        SuanShuUtils.assertArgument(colTo <= toReplace.nCols(), b.C("wz{@\u007f5vl\u007fpzpk5o|a5e{u{gu~,"));
        int a4 = 1;
        int a5 = rowFrom;
        int n = a4;
        while (n <= a2) {
            int a6 = 1;
            int a7 = colFrom;
            int n2 = a6;
            while (n2 <= a3) {
                toReplace.set(a5, a7, replacement.get(a4, a6));
                ++a7;
                n2 = ++a6;
            }
            ++a5;
            n = ++a4;
        }
        return toReplace;
    }

    public static DenseMatrix diagonalMatrix(Matrix A) {
        int a2;
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), b.C("{{{m0t3gm`~f}5vupgnl }bg,t/patl{Zt[4]tGfU-"));
        DenseMatrix a3 = new DenseMatrix(A.nRows(), A.nCols());
        int n = a2 = 1;
        while (n <= A.nRows()) {
            a3.set(a2, a2, A.get(a2, a2));
            n = ++a2;
        }
        return a3;
    }

    public static DenseMatrix rbind(MatrixList matrices) {
        return CreateMatrix.rbind((DenseMatrix[])matrices.toArray());
    }

    @Deprecated
    public static Matrix copyAndReplace(Matrix toReplace, int rowFrom, int rowTo, int colFrom, int colTo, Matrix replacement) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public static DenseMatrix rbind(Vector ... vectors) {
        int a2;
        int a3 = vectors[0].size();
        int a4 = 0;
        Object a5 = vectors;
        int a6 = vectors.length;
        int n = a2 = 0;
        while (n < a6) {
            if (a5[a2] != null) {
                ++a4;
            }
            n = ++a2;
        }
        a5 = new double[a4][];
        int n2 = a6 = 0;
        while (n2 < a4) {
            Vector a7 = vectors[a6];
            if (a7 != null) {
                if (a7.size() != a3) {
                    throw new IllegalArgumentException(b.C("{imyf~y-l\u007f&l!fcjziz-x~hl,"));
                }
                a5[a6] = a7.toArray();
            }
            n2 = ++a6;
        }
        return new DenseMatrix((double[][])a5);
    }
}

