/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.operation;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class ElementaryOperation {
    private DenseMatrix H;

    public void addRow(int row1, int row2, double scale) {
        int a2;
        int n = a2 = 1;
        while (n <= this.H.nCols()) {
            this.H.set(row1, a2, this.H.get(row1, a2) + scale * this.H.get(row2, a2));
            n = ++a2;
        }
    }

    public ElementaryOperation(int nRows, int nCols) {
        this.H = new DenseMatrix(nRows, nCols).ONE();
    }

    public void swapRow(int row1, int row2) {
        int a2;
        Vector a3 = this.H.getRow(row1);
        int a4 = this.H.nCols();
        int n = a2 = 1;
        while (n <= a4) {
            this.H.set(row1, a2, this.H.get(row2, a2));
            n = ++a2;
        }
        int n2 = a2 = 1;
        while (n2 <= a4) {
            this.H.set(row2, a2, a3.get(a2));
            n2 = ++a2;
        }
    }

    public Matrix T() {
        return this.H.deepCopy();
    }

    public ElementaryOperation(Matrix T2) {
        this.H = new DenseMatrix(T2);
    }

    public void addColumn(int col1, int col2, double scale) {
        int a2;
        int n = a2 = 1;
        while (n <= this.H.nRows()) {
            this.H.set(a2, col1, this.H.get(a2, col1) + scale * this.H.get(a2, col2));
            n = ++a2;
        }
    }

    public void swapColumn(int col1, int col2) {
        int a2;
        Vector a3 = this.H.getColumn(col1);
        int n = a2 = 1;
        while (n <= this.H.nRows()) {
            this.H.set(a2, col1, this.H.get(a2, col2));
            n = ++a2;
        }
        int n2 = a2 = 1;
        while (n2 <= this.H.nRows()) {
            this.H.set(a2, col2, a3.get(a2));
            n2 = ++a2;
        }
    }

    public String toString() {
        return this.H.toString();
    }

    public void scaleRow(int row, double scale) {
        int a2;
        int n = a2 = 1;
        while (n <= this.H.nCols()) {
            this.H.set(row, a2, scale * this.H.get(row, a2));
            n = ++a2;
        }
    }

    public ElementaryOperation(int dim) {
        this(dim, dim);
    }

    public double get(int row, int col) {
        return this.H.get(row, col);
    }

    public void scaleColumn(int col, double scale) {
        int a2;
        int n = a2 = 1;
        while (n <= this.H.nRows()) {
            this.H.set(a2, col, scale * this.H.get(a2, col));
            n = ++a2;
        }
    }
}

