/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.operation;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.LU;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class Inverse
extends DenseMatrix {
    public final int dim;
    public final double epsilon;

    public Inverse(LowerTriangularMatrix L, double epsilon) {
        super(L.dim(), L.dim());
        int a2;
        this.dim = L.dim();
        this.epsilon = epsilon;
        int n = a2 = 1;
        while (n <= this.dim) {
            SuanShuUtils.assertArgument(!DoubleUtils.equal(0.0, L.get(a2, a2), epsilon), b.C("J'lu\"inr.ncpou}otk0"));
            this.set(a2, a2, 1.0 / L.get(a2, a2));
            int n2 = a2 + 1;
            while (n2 <= this.dim) {
                int a3;
                double a4 = 0.0;
                int n3 = a2;
                while (true) {
                    int a5;
                    if (n3 > a3 - 1) break;
                    a4 -= L.get(a3, a5) * this.get(a5, a2);
                    n3 = ++a5;
                }
                this.set(a3, a2, a4 / L.get(a3, a3));
                n2 = ++a3;
            }
            n = ++a2;
        }
    }

    public Inverse(Matrix A) {
        this(A, SuanShuUtils.autoEpsilon(A));
    }

    public Inverse(Matrix A, double epsilon) {
        super(A.nCols(), A.nRows());
        this.epsilon = epsilon;
        if (!DimensionCheck.isSquare(A)) {
            throw new IllegalArgumentException(b.C("x^DTGCS\u0011X@J]TUM\u0011U_\u0002BTEGCL\u0010GPYBGI1_|],"));
        }
        this.dim = A.nRows();
        LU a2 = new LU(A, LU.Method.DOOLITTLE, epsilon);
        Inverse a3 = new Inverse(a2.L(), epsilon);
        Inverse a4 = new Inverse(a2.U(), epsilon);
        Matrix a5 = a2.P().rightMultiply(a4.multiply(a3));
        this.overwrite(a5);
    }

    public Inverse(UpperTriangularMatrix U, double epsilon) {
        super(U.dim(), U.dim());
        int a2;
        this.dim = U.dim();
        this.epsilon = epsilon;
        int n = a2 = 1;
        while (n <= this.dim) {
            SuanShuUtils.assertArgument(!DoubleUtils.equal(0.0, U.get(a2, a2), epsilon), b.C("S'lu\"inr.ncpou}otk0"));
            this.set(a2, a2, 1.0 / U.get(a2, a2));
            int n2 = a2 - 1;
            while (true) {
                int a3;
                if (n2 < 1) break;
                double a4 = 0.0;
                int n3 = a3 + 1;
                while (n3 <= this.dim) {
                    int a5;
                    a4 -= U.get(a3, a5) * this.get(a5, a2);
                    n3 = ++a5;
                }
                this.set(a3, a2, a4 / U.get(a3, a3));
                n2 = --a3;
            }
            n = ++a2;
        }
    }

    @Deprecated
    private DenseMatrix H(UpperTriangularMatrix a2, LowerTriangularMatrix a3) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }
}

