/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.operation;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixSingularityException;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.svd.SVD;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.LU;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class Measure {
    public static double tr(Matrix A) {
        int a2;
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), b.C("BETUW\u0017PFN[TSI\u0017VXJN\u0005BM\u0017RG[V_S\nZHBd^-"));
        double a3 = 0.0;
        int n = a2 = 1;
        while (n <= A.nRows()) {
            a3 += A.get(a2, a2);
            n = ++a2;
        }
        return a3;
    }

    public static double Frobenius(Matrix A) {
        int a2;
        double a3 = 0.0;
        int n = a2 = 1;
        while (n <= A.nRows()) {
            int a4;
            int n2 = a4 = 1;
            while (n2 <= A.nCols()) {
                double a5 = A.get(a2, a4);
                a3 += a5 * a5;
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public static double min(Matrix A) {
        int a2;
        double a3 = Double.MAX_VALUE;
        int n = a2 = 1;
        while (n <= A.nRows()) {
            int a4;
            int n2 = a4 = 1;
            while (n2 <= A.nCols()) {
                if (A.get(a2, a4) < a3) {
                    a3 = A.get(a2, a4);
                }
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Deprecated
    public static int nullity(Matrix A) {
        throw new UnsupportedOperationException(b.C("Zzc4c`cdsgkq|5bqp{"));
    }

    public static int rank(Matrix A) {
        return Measure.rank(A, SuanShuUtils.autoEpsilon(A));
    }

    public static double det(Matrix A) {
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(A), b.C("zzzl1u2fla\u007fg|4wtqfom!|cf-pkalfg|[uX!"));
        double a2 = 0.0;
        if (A.nRows() == 1) {
            a2 = A.get(1, 1);
        } else if (A.nRows() == 2) {
            a2 = A.get(1, 1) * A.get(2, 2) - A.get(2, 1) * A.get(1, 2);
        } else if (A.nRows() == 3) {
            a2 = A.get(1, 1) * A.get(2, 2) * A.get(3, 3) - A.get(1, 1) * A.get(2, 3) * A.get(3, 2) - A.get(1, 2) * A.get(2, 1) * A.get(3, 3) + A.get(1, 2) * A.get(2, 3) * A.get(3, 1) + A.get(1, 3) * A.get(2, 1) * A.get(3, 2) - A.get(1, 3) * A.get(2, 2) * A.get(3, 1);
        } else {
            try {
                LU a3 = new LU(A);
                a2 = a3.P().sign();
                UpperTriangularMatrix a4 = a3.U();
                for (int a5 = 1; a5 <= A.nRows(); ++a5) {
                    a2 *= a4.get(a5, a5);
                }
            }
            catch (MatrixSingularityException a6) {
                a2 = 0.0;
            }
        }
        return a2;
    }

    public static double max(Matrix A) {
        int a2;
        double a3 = Double.MIN_VALUE;
        int n = a2 = 1;
        while (n <= A.nRows()) {
            int a4;
            int n2 = a4 = 1;
            while (n2 <= A.nCols()) {
                if (A.get(a2, a4) > a3) {
                    a3 = A.get(a2, a4);
                }
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public static int rank(Matrix A, double epsilon) {
        int a2;
        double[] a3 = new SVD(A, false, SVD.Method.GLOUB_KAHAN, epsilon).singularValues();
        int a4 = 0;
        int n = a2 = 0;
        while (n < Math.min(A.nRows(), A.nCols())) {
            if (a3[a2] > epsilon) {
                ++a4;
            }
            n = ++a2;
        }
        return a4;
    }
}

