/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.operation;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Measure;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class Pow
extends DenseMatrix {
    public final double base;
    public final Matrix B;
    public final int scale;

    public Pow(Matrix A, int exponent, double base) {
        super(A.nCols(), A.nRows());
        SuanShuUtils.assertArgument(exponent > 0, b.C("}`o)hp~foml}%eszm(xl=xqzx|{\u007f0"));
        this.base = base;
        Matrix a2 = A.ONE();
        Matrix a3 = A;
        int a4 = 0;
        int a5 = 0;
        int a6 = 0;
        block0: while (true) {
            int n = exponent;
            while (n > 0) {
                if ((exponent & 1) == 1) {
                    a2 = a2.multiply(a3);
                    a6 += a5;
                }
                Matrix matrix = a2;
                while (Measure.max(matrix) > base) {
                    a2 = a2.scaled(1.0 / base);
                    ++a4;
                    matrix = a2;
                }
                Matrix matrix2 = a3;
                while (Measure.max(matrix2) > base) {
                    a3 = a3.scaled(1.0 / base);
                    ++a5;
                    matrix2 = a3;
                }
                if ((exponent >>>= 1) == 0) continue block0;
                a3 = a3.multiply(a3);
                a5 *= 2;
                n = exponent;
            }
            break;
        }
        this.scale = a4 + a6;
        this.B = a2.deepCopy();
        a2 = this.B.scaled(Math.pow(base, this.scale));
        this.overwrite(a2);
    }

    public Pow(Matrix A, int exponent) {
        this(A, exponent, 1.0E100);
    }
}

