/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.operation;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.svd.SVD;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class PseudoInverse
extends DenseMatrix {
    public final double precision;

    public PseudoInverse(Matrix A, double epsilon) {
        super(A.nCols(), A.nRows());
        int a2;
        SVD a3 = new SVD(A, true, SVD.Method.GLOUB_KAHAN, epsilon);
        DiagonalMatrix a4 = a3.D();
        this.precision = Math.min(this.H(A, a4), epsilon);
        int n = a2 = 1;
        while (n <= a4.nRows()) {
            double a5 = a4.get(a2, a2);
            if (DoubleUtils.compare(a5, 0.0, this.precision) > 0) {
                a4.set(a2, a2, 1.0 / a5);
            } else {
                a4.set(a2, a2, 0.0);
            }
            n = ++a2;
        }
        Matrix a22 = a3.V().multiply(a4).multiply(a3.Ut());
        this.overwrite(a22);
    }

    private double H(Matrix a2, DiagonalMatrix a3) {
        double a4 = DoubleUtils.max(a3.diagonal().toArray());
        double a5 = Math.max(a2.nRows(), a2.nCols());
        return Constant.EPSILON * a4 * a5;
    }

    public PseudoInverse(Matrix A) {
        this(A, SuanShuUtils.autoEpsilon(A));
    }
}

