/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.doubles.operation;

import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.mathoperation.SimpleMatrixMathOperation;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.operation.CreateVector;

public class SubMatrixRef
implements Matrix {
    final int rowTo;
    final Matrix ref;
    final int rowFrom;
    final int colFrom;
    final int colTo;
    final MatrixMathOperation matrixComputation = new SimpleMatrixMathOperation();

    public Vector multiply(Vector v) {
        return this.matrixComputation.multiply((Matrix)this, v);
    }

    @Deprecated
    public void set(int row, int col, double value) throws MatrixAccessException {
        throw new MatrixAccessException(b.C("G`uYqaa}dGzr8|h4mxjattaxi{"));
    }

    public Matrix add(Matrix that) {
        return this.matrixComputation.add(this, that);
    }

    public String toString() {
        return new DenseMatrix(this).toString();
    }

    public Vector getColumn(int col) {
        Vector a2 = CreateVector.subVector(this.ref.getColumn(col + this.colFrom - 1), this.rowFrom, this.rowTo);
        return a2;
    }

    public double get(int row, int col) {
        return this.ref.get(row + this.rowFrom - 1, col + this.colFrom - 1);
    }

    public int nCols() {
        return this.colTo - this.colFrom + 1;
    }

    public Vector getRow(int row) {
        Vector a2 = CreateVector.subVector(this.ref.getRow(row + this.rowFrom - 1), this.colFrom, this.colTo);
        return a2;
    }

    public SubMatrixRef deepCopy() {
        return this;
    }

    public Matrix ONE() {
        return new DenseMatrix(this.nRows(), this.nCols()).ONE();
    }

    public Matrix multiply(Matrix that) {
        return this.matrixComputation.multiply((Matrix)this, that);
    }

    public Matrix scaled(double scalar) {
        return new DenseMatrix(this).scaled(scalar);
    }

    public SubMatrixRef(Matrix A, int rowFrom, int rowTo, int colFrom, int colTo) {
        if (rowFrom < 1) {
            throw new IndexOutOfBoundsException(b.C("@\\FtD\\X\u0012S@\u0019\\QG\u001dDC_HV\u001d\u0013HGYG\tQAFCF2Uc]{\u0013d"));
        }
        if (rowTo > A.nRows()) {
            throw new IndexOutOfBoundsException(b.C("LPJjU\u001fPM\u0016QZJ\u0012IPRG[\u0016\u001eI^GPIK\u0005[Z\\D[z\u001f\\\u0019i\u001fwLyH&"));
        }
        if (colFrom < 1) {
            throw new IndexOutOfBoundsException(b.C("Q\\]tD\\X\u0012S@\u0019\\QG\u001dDC_HV\u001d\u0013HGYG\tQAFCF2Uc]{\u0013d"));
        }
        if (colTo > A.nCols()) {
            throw new IndexOutOfBoundsException(b.C("]PQjU\u001fPM\u0016QZJ\u0012IPRG[\u0016\u001eI^GPIK\u0005[Z\\D[z\u001f\\\u0019i\u001fw]yS&"));
        }
        this.ref = A;
        this.rowFrom = rowFrom;
        this.rowTo = rowTo;
        this.colFrom = colFrom;
        this.colTo = colTo;
    }

    public int nRows() {
        return this.rowTo - this.rowFrom + 1;
    }

    public Matrix minus(Matrix that) {
        return this.matrixComputation.minus(this, that);
    }

    public Matrix t() {
        return new DenseMatrix(this).t();
    }

    public SubMatrixRef(Matrix A) {
        this.ref = A;
        this.rowFrom = 1;
        this.rowTo = A.nRows();
        this.colFrom = 1;
        this.colTo = A.nCols();
    }

    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    public Matrix ZERO() {
        return new DenseMatrix(this.nRows(), this.nCols()).ZERO();
    }
}

