/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.generic.matrixtype;

import com.numericalmethod.suanshu.mathstructure.Field;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.generic.Matrix;
import com.numericalmethod.suanshu.matrix.generic.matrixtype.GenericMatrix;
import com.numericalmethod.suanshu.number.complex.Complex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexMatrix
implements Matrix<ComplexMatrix, Complex> {
    private final GenericMatrix<Complex> H;

    public ComplexMatrix(double[][] data) {
        this(ComplexMatrix.H(data));
    }

    @Override
    public int nRows() {
        return this.H.nRows();
    }

    private ComplexMatrix(GenericMatrix<Complex> a2) {
        ComplexMatrix a3;
        a3.H = a2;
    }

    @Override
    public int nCols() {
        return this.H.nCols();
    }

    public String toString() {
        return this.H.toString();
    }

    public ComplexMatrix(int nRows, int nCols) {
        this.H = new GenericMatrix<Complex>(nRows, nCols, Complex.ZERO);
    }

    public DenseMatrix doubleValue() {
        int a2;
        DenseMatrix a3 = new DenseMatrix(this.nRows(), this.nCols());
        int n = a2 = 1;
        while (n <= this.nRows()) {
            int a4;
            int n2 = a4 = 1;
            while (n2 <= this.nCols()) {
                a3.set(a2, a4, this.H.get(a2, a4).doubleValue());
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public ComplexMatrix add(ComplexMatrix that) {
        return new ComplexMatrix(this.H.add(that.H));
    }

    @Override
    public ComplexMatrix scaled(Complex scalar) {
        return new ComplexMatrix((GenericMatrix<Complex>)this.H.scaled((Field)scalar));
    }

    @Override
    public ComplexMatrix ONE() {
        return new ComplexMatrix((GenericMatrix<Complex>)new GenericMatrix<Complex>(this.nRows(), this.nCols(), Complex.ZERO).ONE());
    }

    @Override
    public Complex get(int row, int col) {
        return this.H.get(row, col);
    }

    @Override
    public ComplexMatrix minus(ComplexMatrix that) {
        return new ComplexMatrix(this.H.minus(that.H));
    }

    @Override
    public void set(int row, int col, Complex value) {
        this.H.set(row, col, value);
    }

    private static Complex[][] H(double[][] a2) {
        int a3;
        int a4 = a2.length;
        int a5 = a2[0].length;
        Complex[][] a6 = new Complex[a4][a5];
        int n = a3 = 0;
        while (n < a4) {
            int a7;
            if (a2[a3].length != a5) {
                throw new IllegalArgumentException(b.C("ptcu0|`4}5uu\u007fr~p$tufa,"));
            }
            int n2 = a7 = 0;
            while (n2 < a5) {
                a6[a3][a7] = new Complex(a2[a3][a7]);
                n2 = ++a7;
            }
            n = ++a3;
        }
        return a6;
    }

    @Override
    public ComplexMatrix opposite() {
        return new ComplexMatrix((GenericMatrix<Complex>)this.H.opposite());
    }

    @Override
    public ComplexMatrix ZERO() {
        return new ComplexMatrix(new GenericMatrix<Complex>(this.nRows(), this.nCols(), Complex.ZERO));
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 61 * a2 + (this.H != null ? this.H.hashCode() : 0);
        return a2;
    }

    public ComplexMatrix(Complex[][] data) {
        this.H = new GenericMatrix((Field[][])data);
    }

    @Override
    public ComplexMatrix multiply(ComplexMatrix that) {
        return new ComplexMatrix(this.H.multiply(that.H));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexMatrix a2 = (ComplexMatrix)obj;
        if (!(this.H == a2.H || this.H != null && this.H.equals(a2.H))) {
            return false;
        }
        return true;
    }
}

