/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.generic.matrixtype;

import com.numericalmethod.suanshu.mathstructure.Field;
import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.MatrixAccessException;
import com.numericalmethod.suanshu.matrix.MatrixDimension;
import com.numericalmethod.suanshu.matrix.generic.Matrix;
import java.lang.reflect.Array;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMatrix<F extends Field<F>>
implements Matrix<GenericMatrix<F>, F> {
    private final int G;
    private final int M;
    private F[][] m;
    private final F H;

    @Override
    public int nRows() {
        return this.M;
    }

    @Override
    public F get(int row, int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        return this.m[row - 1][col - 1];
    }

    @Override
    public GenericMatrix<F> opposite() {
        int a2;
        GenericMatrix<Field> a3 = new GenericMatrix<Field>(this.M, this.G, (Field)this.H.ZERO());
        int n = a2 = 0;
        while (n < this.M) {
            int a4;
            int n2 = a4 = 0;
            while (n2 < this.G) {
                a3.m[a2][a4] = (Field)this.m[a2][a4].opposite();
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public GenericMatrix<F> add(GenericMatrix<F> that) {
        int a2;
        DimensionCheck.throwIfDifferentDimension(this, that);
        GenericMatrix<Field> a3 = new GenericMatrix<Field>(this.M, this.G, (Field)this.H.ZERO());
        int n = a2 = 0;
        while (n < this.M) {
            int a4;
            int n2 = a4 = 0;
            while (n2 < this.G) {
                a3.m[a2][a4] = (Field)this.m[a2][a4].add(that.m[a2][a4]);
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public GenericMatrix<F> ZERO() {
        return new GenericMatrix<Field>(this.M, this.G, (Field)this.H.ZERO());
    }

    private boolean H(F[][] a2) {
        GenericMatrix a3;
        int a4;
        int n = a4 = 0;
        while (n < a3.M) {
            int a5;
            int n2 = a5 = 0;
            while (n2 < a3.G) {
                if (!a3.m[a4][a5].equals(a2[a4][a5])) {
                    return false;
                }
                n2 = ++a5;
            }
            n = ++a4;
        }
        return true;
    }

    @Override
    public GenericMatrix<F> minus(GenericMatrix<F> that) {
        int a2;
        DimensionCheck.throwIfDifferentDimension(this, that);
        GenericMatrix<Field> a3 = new GenericMatrix<Field>(this.M, this.G, (Field)this.H.ZERO());
        int n = a2 = 0;
        while (n < this.M) {
            int a4;
            int n2 = a4 = 0;
            while (n2 < this.G) {
                a3.m[a2][a4] = (Field)this.m[a2][a4].minus(that.m[a2][a4]);
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public GenericMatrix(int nRows, int nCols, F init) {
        int a2;
        this.M = nRows;
        this.G = nCols;
        this.H = init;
        int[] nArray = new int[2];
        nArray[0] = nRows;
        nArray[1] = nCols;
        this.m = (Field[][])Array.newInstance(init.getClass(), nArray);
        int n = a2 = 0;
        while (n < nRows) {
            int a3;
            int n2 = a3 = 0;
            while (n2 < nCols) {
                this.m[a2][a3] = init;
                n2 = ++a3;
            }
            n = ++a2;
        }
    }

    @Override
    public GenericMatrix<F> ONE() {
        int a2;
        GenericMatrix<Field> a3 = new GenericMatrix<Field>(this.M, this.G, (Field)this.H.ZERO());
        int n = a2 = 0;
        while (n < this.M) {
            a3.m[a2][a2] = (Field)this.H.ONE();
            n = ++a2;
        }
        return a3;
    }

    @Override
    public void set(int row, int col, F value) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        this.m[row - 1][col - 1] = value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericMatrix a2 = (GenericMatrix)obj;
        if (!DimensionCheck.sameDimension(this, a2)) {
            return false;
        }
        if (!(this.m == a2.m || this.m != null && a2.m != null && this.H((Field[][])a2.m))) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 61 * a2 + this.M;
        a2 = 61 * a2 + this.G;
        a2 = 61 * a2 + Arrays.deepHashCode(this.m);
        a2 = 61 * a2 + (this.H != null ? this.H.hashCode() : 0);
        return a2;
    }

    @Override
    public GenericMatrix<F> multiply(GenericMatrix<F> that) {
        int a2;
        DimensionCheck.throwIfIncompatible4Multiplication((MatrixDimension)this, that);
        GenericMatrix<Field> a3 = new GenericMatrix<Field>(this.M, that.G, (Field)this.H.ZERO());
        int n = a2 = 0;
        while (n < this.M) {
            int a4;
            int n2 = a4 = 0;
            while (n2 < that.G) {
                int a5;
                Field a6 = (Field)this.H.ZERO();
                int n3 = a5 = 0;
                while (n3 < this.G) {
                    Field a7 = (Field)this.m[a2][a5].multiply(that.m[a5][a4]);
                    a6 = a6.add(a7);
                    n3 = ++a5;
                }
                a3.m[a2][a4] = a6;
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    @Override
    public int nCols() {
        return this.G;
    }

    public GenericMatrix(F[][] data) {
        int a2;
        this.M = data.length;
        this.G = data[0].length;
        this.H = (Field)data[0][0].ZERO();
        int[] nArray = new int[2];
        nArray[0] = this.M;
        nArray[1] = this.G;
        this.m = (Field[][])Array.newInstance(this.H.getClass(), nArray);
        int n = a2 = 0;
        while (n < this.M) {
            int a3;
            if (data[a2].length != this.G) {
                this.m = null;
                throw new IllegalArgumentException(b.C("ptcu0|`4}5uu\u007fr~p$tufa,"));
            }
            int n2 = a3 = 0;
            while (n2 < this.G) {
                this.m[a2][a3] = data[a2][a3];
                n2 = ++a3;
            }
            n = ++a2;
        }
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        Object[] objectArray = new Object[2];
        objectArray[0] = this.M;
        objectArray[1] = this.G;
        a3.append(String.format(b.C("1qo1t_"), objectArray));
        a3.append(b.C("\\"));
        int n = a2 = 1;
        while (n <= this.G) {
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = a2;
            a3.append(String.format(b.C("O92pMu"), objectArray2));
            n = ++a2;
        }
        a3.append("\n");
        int n2 = a2 = 1;
        while (n2 <= this.M) {
            int a4;
            Object[] objectArray3 = new Object[1];
            objectArray3[0] = a2;
            a3.append(String.format(b.C("O0s8Mu"), objectArray3));
            int n3 = a4 = 1;
            while (n3 <= this.G) {
                Object[] objectArray4 = new Object[1];
                objectArray4[0] = this.get(a2, a4).toString();
                a3.append(String.format(b.C("0g:u"), objectArray4));
                n3 = ++a4;
            }
            a3.append("\n");
            n2 = ++a2;
        }
        return a3.toString();
    }

    @Override
    public GenericMatrix<F> scaled(F scalar) {
        int a2;
        GenericMatrix<Field> a3 = new GenericMatrix<Field>(this.M, this.G, (Field)this.H.ZERO());
        int n = a2 = 0;
        while (n < this.M) {
            int a4;
            int n2 = a4 = 0;
            while (n2 < this.G) {
                a3.m[a2][a4] = (Field)this.m[a2][a4].multiply(scalar);
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }
}

