/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.matrix.generic.matrixtype;

import com.numericalmethod.suanshu.mathstructure.Field;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.generic.Matrix;
import com.numericalmethod.suanshu.matrix.generic.matrixtype.GenericMatrix;
import com.numericalmethod.suanshu.number.Real;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealMatrix
implements Matrix<RealMatrix, Real> {
    private final GenericMatrix<Real> H;

    @Override
    public RealMatrix ZERO() {
        return new RealMatrix(new GenericMatrix<Real>(this.nRows(), this.nCols(), Real.ZERO));
    }

    public String toString() {
        return this.H.toString();
    }

    @Override
    public void set(int row, int col, Real value) {
        this.H.set(row, col, value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RealMatrix a2 = (RealMatrix)obj;
        if (!(this.H == a2.H || this.H != null && this.H.equals(a2.H))) {
            return false;
        }
        return true;
    }

    public DenseMatrix doubleValue() {
        int a2;
        DenseMatrix a3 = new DenseMatrix(this.nRows(), this.nCols());
        int n = a2 = 1;
        while (n <= this.nRows()) {
            int a4;
            int n2 = a4 = 1;
            while (n2 <= this.nCols()) {
                a3.set(a2, a4, this.H.get(a2, a4).doubleValue());
                n2 = ++a4;
            }
            n = ++a2;
        }
        return a3;
    }

    public RealMatrix(double[][] data) {
        this(RealMatrix.H(data));
    }

    public RealMatrix(Real[][] data) {
        this.H = new GenericMatrix((Field[][])data);
    }

    @Override
    public int nRows() {
        return this.H.nRows();
    }

    @Override
    public Real get(int row, int col) {
        return this.H.get(row, col);
    }

    @Override
    public RealMatrix multiply(RealMatrix that) {
        return new RealMatrix(this.H.multiply(that.H));
    }

    @Override
    public RealMatrix minus(RealMatrix that) {
        return new RealMatrix(this.H.minus(that.H));
    }

    public RealMatrix(int nRows, int nCols) {
        this.H = new GenericMatrix<Real>(nRows, nCols, Real.ZERO);
    }

    private static Real[][] H(double[][] a2) {
        int a3;
        int a4 = a2.length;
        int a5 = a2[0].length;
        Real[][] a6 = new Real[a4][a5];
        int n = a3 = 0;
        while (n < a4) {
            int a7;
            if (a2[a3].length != a5) {
                throw new IllegalArgumentException(b.C("ptcu0|`4}5uu\u007fr~p$tufa,"));
            }
            int n2 = a7 = 0;
            while (n2 < a5) {
                a6[a3][a7] = new Real(a2[a3][a7]);
                n2 = ++a7;
            }
            n = ++a3;
        }
        return a6;
    }

    private RealMatrix(GenericMatrix<Real> a2) {
        RealMatrix a3;
        a3.H = a2;
    }

    @Override
    public int nCols() {
        return this.H.nCols();
    }

    @Override
    public RealMatrix scaled(Real scalar) {
        return new RealMatrix((GenericMatrix<Real>)this.H.scaled((Field)scalar));
    }

    @Override
    public RealMatrix add(RealMatrix that) {
        return new RealMatrix(this.H.add(that.H));
    }

    @Override
    public RealMatrix opposite() {
        return new RealMatrix((GenericMatrix<Real>)this.H.opposite());
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 37 * a2 + (this.H != null ? this.H.hashCode() : 0);
        return a2;
    }

    @Override
    public RealMatrix ONE() {
        return new RealMatrix((GenericMatrix<Real>)new GenericMatrix<Real>(this.nRows(), this.nCols(), Real.ZERO).ONE());
    }
}

