/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.misc;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class SuanShuUtils {
    public static void assertOrThrow(RuntimeException error) {
        if (error != null) {
            throw error;
        }
    }

    public static double autoEpsilon(double ... inputs) {
        double a2 = Math.abs(DoubleUtils.max(inputs)) * Math.sqrt(inputs.length) * Constant.EPSILON * 10.0;
        if (a2 == 0.0) {
            a2 = Double.MIN_NORMAL;
        }
        return a2;
    }

    public static void assertArgument(boolean condition, String errorMessage) {
        if (!condition) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static double autoEpsilon(double[] ... inputs) {
        int a2;
        double a3 = 0.0;
        double[][] a4 = inputs;
        int a5 = inputs.length;
        int n = a2 = 0;
        while (n < a5) {
            double a6 = SuanShuUtils.autoEpsilon(a4[a2]);
            if (a6 > a3) {
                a3 = a6;
            }
            n = ++a2;
        }
        return a3;
    }

    public static double autoEpsilon(Matrix A) {
        return SuanShuUtils.autoEpsilon(MatrixUtils.to1DArray(A));
    }

    private SuanShuUtils() {
        SuanShuUtils a2;
    }

    static {
        Package.getInstance(b.C("SQAX\u0016")).validate();
    }
}

