/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.number;

import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Counter {
    public final int scale;
    private final Map<Double, Integer> H = new HashMap<Double, Integer>();

    public Counter() {
        this.scale = Integer.MAX_VALUE;
    }

    public synchronized int count(double number) {
        Double a2 = new Double(this.H(number));
        if (this.H.containsKey(a2)) {
            return this.H.get(a2);
        }
        return 0;
    }

    private double H(double a2) {
        Counter a3;
        double a4 = a2;
        if (a3.scale != Integer.MAX_VALUE) {
            a4 = DoubleUtils.round(a2, a3.scale);
        }
        return a4;
    }

    public Set<Double> keySet() {
        return this.H.keySet();
    }

    public Counter(int scale) {
        this.scale = scale;
    }

    public synchronized void add(double ... numbers) {
        int a2;
        int n = a2 = 0;
        while (n < numbers.length) {
            this.add(numbers[a2]);
            n = ++a2;
        }
    }

    public synchronized void add(double number) {
        Double a2 = new Double(this.H(number));
        int a3 = 0;
        if (this.H.containsKey(a2)) {
            a3 = this.H.get(a2);
        }
        this.H.put(a2, a3 + 1);
    }
}

