/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.number;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.mathstructure.Field;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Real
extends Number
implements Field<Real>,
Comparable<Real> {
    public static final Real ZERO = new Real(BigDecimal.ZERO);
    private final BigDecimal H;
    private static final long serialVersionUID = 1L;
    public static final Real ONE = new Real(BigDecimal.ONE);

    @Override
    public Real inverse() throws Field.InverseNonExistent {
        return ((Real)this.ONE()).divide(this);
    }

    public Real(String value) {
        this.H = new BigDecimal(value);
    }

    @Override
    public float floatValue() {
        return this.H.floatValue();
    }

    public Real divide(Real that, int scale) {
        return new Real(this.H.divide(that.H, scale, 6));
    }

    public Real(BigDecimal value) {
        this.H = value;
    }

    @Override
    public int compareTo(Real that) {
        return this.H.compareTo(that.H);
    }

    @Override
    public double doubleValue() {
        return this.H.doubleValue();
    }

    @Override
    public Real multiply(Real that) {
        return new Real(this.H.multiply(that.H));
    }

    @Override
    public Real divide(Real that) {
        return this.divide(that, Constant.MACH_SCALE);
    }

    @Override
    public Real opposite() {
        return new Real(this.H.negate());
    }

    @Override
    public long longValue() {
        return this.H.longValue();
    }

    @Override
    public Real minus(Real that) {
        return this.add((Real)that.opposite());
    }

    public Real(double value) {
        this.H = BigDecimal.valueOf(value);
    }

    public Real(BigInteger value) {
        this.H = new BigDecimal(value);
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 29 * a2 + (this.H != null ? this.H.hashCode() : 0);
        return a2;
    }

    @Override
    public int intValue() {
        return this.H.intValue();
    }

    @Override
    public Real ZERO() {
        return ZERO;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Real a2 = (Real)obj;
        if (this.H != a2.H && (this.H == null || this.H.compareTo(a2.H) != 0)) {
            return false;
        }
        return true;
    }

    public Real(long value) {
        this.H = BigDecimal.valueOf(value);
    }

    @Override
    public Real add(Real that) {
        return new Real(this.H.add(that.H));
    }

    public String toString() {
        return this.H.stripTrailingZeros().toString();
    }

    @Override
    public Real ONE() {
        return ONE;
    }

    public BigDecimal bigDecimal() {
        return this.H;
    }
}

