/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.number;

import com.numericalmethod.suanshu.number.big.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ScientificNotation
extends Number {
    public final int exponent;
    private static final long serialVersionUID = 1L;
    private final BigDecimal H = BigDecimal.valueOf(10L);
    public final BigDecimal significand;

    public ScientificNotation(BigInteger x2) {
        this(new BigDecimal(x2));
    }

    public ScientificNotation(double x2) {
        this(new BigDecimal(x2));
    }

    public ScientificNotation(BigDecimal significand, int exponent) {
        this.significand = significand;
        this.exponent = exponent;
    }

    public ScientificNotation(double significand, int exponent) {
        this.significand = new BigDecimal(significand);
        this.exponent = exponent;
    }

    public BigDecimal value() {
        BigDecimal a2 = BigDecimalUtils.pow(this.H, this.exponent, Math.abs(this.exponent));
        BigDecimal a3 = this.significand.multiply(a2);
        a3.stripTrailingZeros();
        return a3;
    }

    public ScientificNotation(long x2) {
        this(BigInteger.valueOf(x2));
    }

    public long longValue() {
        return this.value().longValue();
    }

    public ScientificNotation(BigDecimal x2) {
        BigDecimal a2;
        if (x2.equals(BigDecimal.ZERO)) {
            this.significand = BigDecimal.ZERO;
            this.exponent = 0;
            return;
        }
        int a3 = 0;
        BigDecimal bigDecimal = a2 = x2.abs();
        while (bigDecimal.compareTo(this.H) >= 0) {
            ++a3;
            bigDecimal = a2.divide(this.H);
        }
        BigDecimal bigDecimal2 = a2;
        while (bigDecimal2.compareTo(BigDecimal.ONE) < 0) {
            --a3;
            bigDecimal2 = a2.multiply(this.H);
        }
        this.significand = x2.signum() > 0 ? a2 : a2.negate();
        this.exponent = a3;
    }

    public float floatValue() {
        return this.value().floatValue();
    }

    public double doubleValue() {
        return this.value().doubleValue();
    }

    public int intValue() {
        return this.value().intValue();
    }
}

