/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.number.big;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.big.BigIntegerUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigDecimalUtils {
    public static final BigDecimal PI = new BigDecimal(b.C("';& ! *&* ,! ,,-7'4,4#1\"8&<,;'<-\u0001%\u0005,\b!\u0002-\u000b$\t-\u000b,\u0002'\u0013 \u0016$\u0015-\u0011$\u0015\"\u001b-\u001c!\u001e-&&'#($% ,#-,.'+,=,?\"2-3'8-=!;!9%\u0005\"\u0007\"\u0007l"));

    private BigDecimalUtils() {
        BigDecimalUtils a2;
    }

    public static BigDecimal pow(BigDecimal a2, BigDecimal b2, int scale) {
        BigDecimal a3 = b2;
        a3 = a3.multiply(BigDecimalUtils.log(a2, scale));
        a3 = BigDecimalUtils.exp(a3, scale);
        return a3;
    }

    public static BigDecimal sum(BigDecimal ... big) {
        int a2;
        BigDecimal a3 = BigDecimal.ZERO;
        BigDecimal[] a4 = big;
        int a5 = big.length;
        int n = a2 = 0;
        while (n < a5) {
            BigDecimal a6 = a4[a2];
            a3 = a3.add(a6);
            n = ++a2;
        }
        return a3;
    }

    public static BigDecimal pow(BigDecimal a2, BigDecimal b2) {
        return BigDecimalUtils.pow(a2, b2, Constant.MACH_SCALE);
    }

    private static BigDecimal C(BigDecimal a2, int a3) {
        BigDecimal a4 = BigDecimal.ZERO;
        BigDecimal a5 = BigDecimal.ONE;
        int a6 = 1;
        BigDecimal bigDecimal = a4;
        while (bigDecimal.compareTo(a5) != 0) {
            a4 = a5;
            BigDecimal a7 = a2.pow(a6);
            BigInteger a8 = BigIntegerUtils.factorial(a6);
            a7 = a7.divide(new BigDecimal(a8), a3 + 1, 6);
            a5 = a4.add(a7);
            ++a6;
            bigDecimal = a4;
        }
        return a4.setScale(a3, 6);
    }

    public static BigDecimal exp(BigDecimal x2, int scale) {
        int a2 = BigDecimalUtils.getWhole(x2).intValue();
        BigDecimal a3 = BigDecimalUtils.getFractional(x2);
        BigDecimal a4 = BigDecimalUtils.pow(BigDecimalUtils.C(BigDecimal.ONE, scale), a2, scale);
        BigDecimal a5 = BigDecimalUtils.C(a3, scale);
        BigDecimal a6 = a4.multiply(a5);
        return a6.setScale(scale, 6);
    }

    public static BigDecimal pow(BigDecimal a2, int b2, int scale) {
        if (b2 < 0) {
            return BigDecimal.ONE.divide(BigDecimalUtils.pow(a2, -b2, scale), scale, 6);
        }
        return a2.pow(b2).setScale(scale, 6);
    }

    public static BigDecimal exp(double x2, int scale) {
        return BigDecimalUtils.exp(BigDecimal.valueOf(x2), scale);
    }

    private static BigDecimal H(BigDecimal a2, int a3) {
        BigDecimal a4;
        SuanShuUtils.assertArgument(a2.signum() > 0, b.C("a8wlnl>{t8,9e"));
        int a5 = 2 * a3;
        BigDecimal a6 = a2;
        if (a6.compareTo(BigDecimal.valueOf(10L)) == 0) {
            a6 = BigDecimal.valueOf(2.302585092994);
        } else if (a6.compareTo(BigDecimal.valueOf(1L)) == 0) {
            a6 = BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = a4 = BigDecimal.ONE;
        while (!BigDecimalUtils.equals(bigDecimal, BigDecimal.ZERO, a3)) {
            BigDecimal a7 = BigDecimalUtils.exp(a6, a5);
            a4 = BigDecimal.ONE.subtract(a2.divide(a7, a5, 6));
            a6 = a6.subtract(a4);
            bigDecimal = a4;
        }
        return a6.setScale(a3, 6);
    }

    public static BigDecimal exp(double x2) {
        return BigDecimalUtils.exp(x2, Constant.MACH_SCALE);
    }

    public static boolean equals(BigDecimal n1, BigDecimal n2, int precision) {
        return BigDecimalUtils.compare(n1, n2, precision) == 0;
    }

    public static BigDecimal log(BigDecimal x2) {
        return BigDecimalUtils.log(x2, Constant.MACH_SCALE);
    }

    public static BigDecimal pow(BigDecimal a2, int b2) {
        return BigDecimalUtils.pow(a2, b2, Constant.MACH_SCALE);
    }

    public static BigDecimal exp(BigDecimal x2) {
        return BigDecimalUtils.exp(x2, Constant.MACH_SCALE);
    }

    public static int compare(BigDecimal n1, BigDecimal n2, int precision) {
        BigDecimal a2 = BigDecimal.ONE.movePointLeft(precision);
        int a3 = n1.subtract(n2).abs().compareTo(a2);
        return a3 <= 0 ? 0 : n1.compareTo(n2);
    }

    public static BigDecimal getWhole(BigDecimal num) {
        return num.setScale(0, 1);
    }

    public static BigDecimal sum(double ... big) {
        int a2;
        BigDecimal a3 = BigDecimal.ZERO;
        double[] a4 = big;
        int a5 = big.length;
        int n = a2 = 0;
        while (n < a5) {
            double a6 = a4[a2];
            a3 = a3.add(BigDecimal.valueOf(a6));
            n = ++a2;
        }
        return a3;
    }

    public static BigDecimal getFractional(BigDecimal num) {
        return num.subtract(BigDecimalUtils.getWhole(num));
    }

    public static BigDecimal log(BigDecimal x2, int scale) {
        BigDecimal a2;
        if (x2.compareTo(BigDecimal.TEN) < 0) {
            a2 = BigDecimalUtils.H(x2, scale);
        } else {
            int a3 = x2.precision() - x2.scale() - 1;
            BigDecimal a4 = BigDecimal.valueOf(10L).pow(a3);
            BigDecimal a5 = x2.divide(a4);
            BigDecimal a6 = BigDecimalUtils.H(BigDecimal.valueOf(10L), scale);
            BigDecimal a7 = BigDecimalUtils.H(a5, scale);
            a2 = BigDecimal.valueOf(a3).multiply(a6).add(a7);
        }
        return a2.setScale(scale, 6);
    }
}

