/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.number.big;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import java.math.BigInteger;

public class BigIntegerUtils {
    private BigIntegerUtils() {
        BigIntegerUtils a2;
    }

    public static BigInteger permutation(int n, int k2) {
        int a2;
        SuanShuUtils.assertArgument(n >= k2, b.C("z5))0>"));
        SuanShuUtils.assertArgument(k2 >= 0, b.C("z97\u007f0xfgh5}q8%h4kg'zaavfmy/z}xiqF&"));
        if (n == 0 || k2 == 0 || k2 == n) {
            return BigInteger.valueOf(1L);
        }
        BigInteger a3 = BigInteger.valueOf(1L);
        int n2 = a2 = n;
        while (n2 > n - k2) {
            a3 = a3.multiply(BigInteger.valueOf(a2));
            n2 = --a2;
        }
        return a3;
    }

    public static BigInteger combination(int n, int k2) {
        SuanShuUtils.assertArgument(n >= k2, b.C("z5))0>"));
        SuanShuUtils.assertArgument(k2 >= 0, b.C("z97\u007f0xfgh5}q8%h4kg'zaavfmy/z}xiqF&"));
        if (n == 0 || k2 == 0 || k2 == n) {
            return BigInteger.valueOf(1L);
        }
        if ((double)k2 > (double)n / 2.0) {
            k2 = n - k2;
        }
        BigInteger a2 = BigIntegerUtils.permutation(n, k2);
        BigInteger a3 = BigIntegerUtils.factorial(k2);
        a2 = a2.divide(a3);
        return a2;
    }

    public static BigInteger factorial(int n) {
        int a2;
        SuanShuUtils.assertArgument(n >= 0, b.C("d+d\u007f}\u007f-hg+1*iy%k:ex~ky|f2edgtn'"));
        BigInteger a3 = BigInteger.valueOf(1L);
        int n2 = a2 = 2;
        while (n2 <= n) {
            a3 = a3.multiply(BigInteger.valueOf(a2));
            n2 = ++a2;
        }
        return a3;
    }
}

