/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.number.complex;

import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.complex.Complex;

public class ElementaryFunction {
    public static Complex sqrt(Complex z2) {
        double a2;
        ElementaryFunction.H(z2);
        double a3 = Math.abs(z2.real);
        double a4 = Math.abs(z2.imaginary);
        if (DoubleUtils.compare(z2.real, 0.0) == 0 && DoubleUtils.compare(z2.imaginary, 0.0) == 0) {
            return new Complex(0.0, 0.0);
        }
        if (a3 >= a4) {
            double a5 = a4 / a3;
            a2 = Math.sqrt(a3) * Math.sqrt((1.0 + Math.sqrt(1.0 + a5 * a5)) / 2.0);
        } else {
            double a6 = a3 / a4;
            a2 = Math.sqrt(a4) * Math.sqrt((a6 + Math.sqrt(1.0 + a6 * a6)) / 2.0);
        }
        Complex a7 = DoubleUtils.compare(z2.real, 0.0) >= 0 ? new Complex(a2, z2.imaginary / a2 / 2.0) : (DoubleUtils.compare(z2.imaginary, 0.0) >= 0 ? new Complex(a4 / a2 / 2.0, a2) : new Complex(a4 / a2 / 2.0, -a2));
        return a7;
    }

    public static Complex atan(Complex z2) {
        ElementaryFunction.H(z2);
        return new Complex(0.0, 0.5).multiply(ElementaryFunction.log(Complex.ONE.minus(Complex.I.multiply(z2))).minus(ElementaryFunction.log(Complex.ONE.add(Complex.I.multiply(z2)))));
    }

    public static Complex tan(Complex z2) {
        ElementaryFunction.H(z2);
        double a2 = z2.real * 2.0;
        double a3 = z2.imaginary * 2.0;
        double a4 = Math.cos(a2) + Math.cosh(a3);
        return new Complex(Math.sin(a2) / a4, Math.sinh(a3) / a4);
    }

    public static Complex acos(Complex z2) {
        ElementaryFunction.H(z2);
        return new Complex(1.5707963267948966, 0.0).minus(ElementaryFunction.asin(z2));
    }

    public static Complex log(Complex z2) {
        ElementaryFunction.H(z2);
        if (z2.equals(z2.ZERO())) {
            return Complex.NEGATIVE_INFINITY;
        }
        return new Complex(Math.log(z2.modulus()), Math.atan2(z2.imaginary, z2.real));
    }

    public static Complex sin(Complex z2) {
        ElementaryFunction.H(z2);
        return new Complex(Math.sin(z2.real) * Math.cosh(z2.imaginary), Math.cos(z2.real) * Math.sinh(z2.imaginary));
    }

    public static Complex asin(Complex z2) {
        ElementaryFunction.H(z2);
        return ((Complex)Complex.I.opposite()).multiply(ElementaryFunction.log(Complex.I.multiply(z2).add(ElementaryFunction.sqrt(z2.ONE().minus(z2.multiply(z2))))));
    }

    public static Complex cosh(Complex z2) {
        ElementaryFunction.H(z2);
        return new Complex(Math.cosh(z2.real) * Math.cos(z2.imaginary), Math.sinh(z2.real) * Math.sin(z2.imaginary));
    }

    public static Complex pow(Complex z1, Complex z2) {
        ElementaryFunction.H(z1);
        ElementaryFunction.H(z2);
        double a2 = z1.modulus();
        if (DoubleUtils.compare(a2, 0.0) == 0) {
            return z1.ZERO();
        }
        double a3 = Math.atan2(z1.imaginary, z1.real);
        return Complex.fromPolar(Math.pow(a2, z2.real) / Math.exp(z2.imaginary * a3), z2.imaginary * Math.log(a2) + z2.real * a3);
    }

    public static Complex tanh(Complex z2) {
        ElementaryFunction.H(z2);
        double a2 = z2.real * 2.0;
        double a3 = z2.imaginary * 2.0;
        double a4 = Math.cosh(a2) + Math.cos(a3);
        return new Complex(Math.sinh(a2) / a4, Math.sin(a3) / a4);
    }

    public static Complex sinh(Complex z2) {
        ElementaryFunction.H(z2);
        return new Complex(Math.sinh(z2.real) * Math.cos(z2.imaginary), Math.cosh(z2.real) * Math.sin(z2.imaginary));
    }

    public static Complex exp(Complex z2) {
        ElementaryFunction.H(z2);
        return Complex.fromPolar(Math.exp(z2.real), z2.imaginary);
    }

    public static Complex cos(Complex z2) {
        ElementaryFunction.H(z2);
        return new Complex(Math.cos(z2.real) * Math.cosh(z2.imaginary), -Math.sin(z2.real) * Math.sinh(z2.imaginary));
    }

    private static boolean H(Complex a2) {
        if (Complex.isNaN(a2) || Complex.isInfinite(a2)) {
            throw new IllegalArgumentException(b.C("`}~g0xv`tz{4qf;zka'pesjziq/rgg+ZU[\u0017{B5zZz\\q]l\f"));
        }
        return true;
    }
}

