/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.optimization.constrained.general.ConstrainedMinimizer;
import com.numericalmethod.suanshu.optimization.constrained.general.ConstrainedProblem;
import com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod.Courant;
import com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod.Fletcher;
import com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod.PenaltyFunction;
import com.numericalmethod.suanshu.optimization.constrained.general.penaltymethod.SumOfPenalties;
import com.numericalmethod.suanshu.optimization.unconstrained.NelderMead;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedMinimizer;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedProblem;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class PenaltyMethod
implements ConstrainedMinimizer {
    public final PenaltyFunctionFactory penaltyFunctionFactory;
    private double G;
    private ConstrainedProblem M;
    private double m;
    public static final PenaltyFunctionFactory DEFAULT_PENALTY_FUNCTION_FACTORY = new PenaltyFunctionFactory(){
        {
            1 a2;
        }

        public PenaltyFunction getPenaltyFunction(ConstrainedProblem problem) {
            PenaltyFunction[] penaltyFunctionArray = new PenaltyFunction[2];
            penaltyFunctionArray[0] = new Courant(problem.equalities);
            penaltyFunctionArray[1] = new Fletcher(problem.inequalities);
            return new SumOfPenalties(penaltyFunctionArray);
        }
    };
    public final UnconstrainedMinimizer solver;
    public final double gamma;
    private PenaltyFunction H;

    public PenaltyMethod(PenaltyFunctionFactory penaltyFunctionFactory, double gamma, UnconstrainedMinimizer solver) {
        this.penaltyFunctionFactory = penaltyFunctionFactory;
        this.gamma = gamma;
        this.solver = solver;
    }

    public Vector search(int maxIterations, Vector ... initials) {
        double d2;
        Vector a2 = null;
        RealScalarFunction a3 = this.H(this.gamma);
        this.solver.solve(new UnconstrainedProblem(a3), this.m);
        Vector a4 = this.solver.search(maxIterations, initials);
        double a5 = this.M.f.evaluate(a4.toArray());
        if (d2 < this.G) {
            this.G = a5;
            a2 = a4;
        }
        return a2;
    }

    public PenaltyMethod(double gamma) {
        this(DEFAULT_PENALTY_FUNCTION_FACTORY, gamma, new NelderMead());
    }

    public void solve(ConstrainedProblem problem, double tol) {
        this.M = problem;
        this.H = this.penaltyFunctionFactory.getPenaltyFunction(problem);
        this.m = tol;
        this.G = Double.POSITIVE_INFINITY;
    }

    public double minimum() {
        return this.G;
    }

    private RealScalarFunction H(final double a2) {
        PenaltyMethod a3;
        return new RealScalarFunction(){

            public int dimension4Domain() {
                return ((PenaltyMethod)PenaltyMethod.this).M.f.dimension4Domain();
            }

            public double evaluate(double ... x2) {
                double a22 = ((PenaltyMethod)PenaltyMethod.this).M.f.evaluate(x2);
                double a3 = PenaltyMethod.this.H.evaluate(x2);
                return a22 + a2 * a3;
            }
            {
                2 a22;
            }

            public int dimension4Range() {
                return ((PenaltyMethod)PenaltyMethod.this).M.f.dimension4Range();
            }
        };
    }

    public PenaltyMethod() {
        this(1.0E30);
    }

    public static interface PenaltyFunctionFactory {
        public PenaltyFunction getPenaltyFunction(ConstrainedProblem var1);
    }
}

