/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.problem;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.problem.LpProblem;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.problem.StandardLpProblem1;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class StandardLpProblem2
implements LpProblem {
    public final ImmutableVector c;
    public final ImmutableVector b;
    public final ImmutableMatrix A;

    public StandardLpProblem2(Vector c2, Matrix A, Vector b2) throws LpProblem.EmptyCostVector, LpProblem.NoConstraint, LpProblem.DimensionNotMatched {
        this.c = new ImmutableVector(c2);
        this.A = new ImmutableMatrix(A);
        this.b = new ImmutableVector(b2);
        this.validate();
    }

    protected void validate() throws LpProblem.EmptyCostVector, LpProblem.NoConstraint, LpProblem.DimensionNotMatched {
        int a2;
        if (this.c == null) {
            throw new LpProblem.EmptyCostVector();
        }
        if (this.A == null || this.b == null) {
            throw new LpProblem.NoConstraint();
        }
        if (this.A.nRows() != this.b.size()) {
            throw new LpProblem.DimensionNotMatched(b.C("q}{p\u007fg{zs4pzm4wtqwnpe4dz\u007f4z}l4c{PeCt]}Fl\u001dwQ{J`HtLzR&"));
        }
        int n = a2 = 1;
        while (n <= this.b.size()) {
            SuanShuUtils.assertArgument(this.b.get(a2) <= 0.0, b.C("s0\u22761e"));
            n = ++a2;
        }
    }

    public StandardLpProblem2(StandardLpProblem1 problem1) throws LpProblem.EmptyCostVector, LpProblem.NoConstraint, LpProblem.DimensionNotMatched {
        this(problem1.c, problem1.A.scaled(-1.0), problem1.b.scaled(-1.0));
    }
}

