/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;

public class JordanExchange
extends DenseMatrix {
    public JordanExchange(Matrix A, int r, int s, double epsilon) {
        super(A.nRows(), A.nCols());
        int a2;
        double a3 = A.get(r, s);
        if (DoubleUtils.compare(a3, 0.0, epsilon) == 0) {
            Object[] objectArray = new Object[2];
            objectArray[0] = r;
            objectArray[1] = s;
            throw new RuntimeException(String.format(b.C("WI\\B\t\\C[JX\u0006KNYLI\u001dMJ\rb\t^\u0001\u0015\tRp\u0011\u0004^DcIo_)Ho]`BbHoOg\ryIjHzX\u007fI|"), objectArray));
        }
        int n = a2 = 1;
        while (n <= A.nCols()) {
            this.set(r, a2, -A.get(r, a2) / a3);
            n = ++a2;
        }
        int n2 = a2 = 1;
        while (n2 <= A.nRows()) {
            this.set(a2, s, A.get(a2, s) / a3);
            n2 = ++a2;
        }
        this.set(r, s, 1.0 / a3);
        int n3 = a2 = 1;
        while (n3 <= A.nRows()) {
            int a4;
            int n4 = a4 = 1;
            while (n4 <= A.nCols()) {
                if (a2 != r && a4 != s) {
                    this.set(a2, a4, A.get(a2, a4) - this.get(a2, s) * A.get(r, a4));
                }
                n4 = ++a4;
            }
            n3 = ++a2;
        }
    }

    public JordanExchange(Matrix A, int r, int s) {
        this(A, r, s, SuanShuUtils.autoEpsilon(MatrixUtils.to1DArray(A)));
    }
}

