/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.CreateMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.problem.StandardLpProblem2;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.JordanExchange;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class Tableau {
    private Label[] M;
    private Label[] m;
    public final double epsilon;
    public static final Label UNDEFINED = new Label(LabelType.UNDEFINED, Integer.MAX_VALUE);
    private Matrix H;

    public ImmutableVector minimizer() {
        int a2;
        DenseVector a3 = new DenseVector(this.problemSize(), 0.0);
        int n = a2 = 1;
        while (true) {
            if (n > this.nRows() - 1) break;
            if (this.getRowLabel((int)a2).type == LabelType.VARIABLE) {
                a3.set(this.getRowLabel((int)a2).index, this.get(a2, this.nCols()));
            }
            n = ++a2;
        }
        return new ImmutableVector(a3);
    }

    public double min() {
        return this.H.get(this.nRows(), this.nCols());
    }

    public void swap(int r, int s) {
        this.H = new JordanExchange(this.H, r, s, this.epsilon);
        Label a2 = this.m[r];
        this.m[r] = this.M[s];
        this.M[s] = a2;
    }

    public int problemSize() {
        return this.nCols() - 1;
    }

    public int nCols() {
        return this.H.nCols();
    }

    public Label getRowLabel(int i2) {
        return this.m[i2];
    }

    public Tableau(StandardLpProblem2 problem) {
        this(Tableau.buildTable(problem), SuanShuUtils.autoEpsilon(MatrixUtils.to1DArray(problem.A)));
    }

    public Tableau(Matrix T2, double epsilon) {
        int a2;
        this.m = new Label[T2.nRows() + 1];
        this.M = new Label[T2.nCols() + 1];
        this.m[0] = UNDEFINED;
        int n = a2 = 1;
        while (n < T2.nRows()) {
            this.m[a2] = new Label(LabelType.CONSTRAINT, a2);
            n = ++a2;
        }
        this.m[T2.nRows()] = new Label(LabelType.COST, 0);
        this.M[0] = UNDEFINED;
        int n2 = a2 = 1;
        while (n2 < T2.nCols()) {
            this.M[a2] = new Label(LabelType.VARIABLE, a2);
            n2 = ++a2;
        }
        this.M[T2.nCols()] = new Label(LabelType.B, 0);
        this.H = new DenseMatrix(T2);
        this.epsilon = epsilon;
    }

    public int nRows() {
        return this.H.nRows();
    }

    public double getCostRow(int col) {
        return this.H.get(this.H.nRows(), col);
    }

    public boolean isFeasible() {
        int a2;
        int a3 = this.nRows() - 1;
        int n = a2 = 1;
        while (n <= a3) {
            if (DoubleUtils.compare(this.getBCol(a2), 0.0, this.epsilon) < 0) {
                return false;
            }
            n = ++a2;
        }
        return true;
    }

    public double getBCol(int row) {
        return this.H.get(row, this.H.nCols());
    }

    public Tableau(Label[] rowLabel, Label[] colLabel, Matrix T2, double epsilon) {
        this.m = Arrays.copyOf(rowLabel, rowLabel.length);
        this.M = Arrays.copyOf(colLabel, colLabel.length);
        this.H = new DenseMatrix(T2);
        this.epsilon = epsilon;
    }

    public static DenseMatrix buildTable(StandardLpProblem2 problem) {
        DenseMatrix a2 = new DenseMatrix(problem.b).scaled(-1.0);
        Matrix[] matrixArray = new Matrix[2];
        matrixArray[0] = problem.A;
        matrixArray[1] = a2;
        DenseMatrix a3 = CreateMatrix.cbind(matrixArray);
        Matrix[] matrixArray2 = new Matrix[2];
        matrixArray2[0] = new DenseMatrix(problem.c).t();
        matrixArray2[1] = new DenseMatrix(1, 1).ZERO();
        DenseMatrix a4 = CreateMatrix.cbind(matrixArray2);
        Matrix[] matrixArray3 = new Matrix[2];
        matrixArray3[0] = a3;
        matrixArray3[1] = a4;
        DenseMatrix a5 = CreateMatrix.rbind(matrixArray3);
        return new DenseMatrix((Matrix)a5);
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        Object[] objectArray = new Object[2];
        objectArray[0] = this.H.nRows();
        objectArray[1] = this.H.nCols();
        a3.append(String.format(b.C("1qo1t_"), objectArray));
        a3.append(b.C("\u001d\\"));
        int n = a2 = 1;
        while (n < this.M.length) {
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = this.M[a2].toString();
            a3.append(String.format(b.C("O92gMu"), objectArray2));
            n = ++a2;
        }
        a3.append("\n");
        int n2 = a2 = 1;
        while (n2 <= this.H.nRows()) {
            int a4;
            if (a2 < this.m.length) {
                Object[] objectArray3 = new Object[1];
                objectArray3[0] = this.m[a2].toString();
                a3.append(String.format(b.C("O0d8Mu"), objectArray3));
            }
            a3.append(b.C("\\"));
            int n3 = a4 = 1;
            while (n3 <= this.H.nCols()) {
                Object[] objectArray4 = new Object[1];
                objectArray4[0] = this.get(a2, a4);
                a3.append(String.format(b.C("0r:u"), objectArray4));
                n3 = ++a4;
            }
            a3.append("\n");
            n2 = ++a2;
        }
        return a3.toString();
    }

    public Tableau(Tableau table) {
        this(table.m, table.M, table.H, table.epsilon);
    }

    public double get(int row, int col) {
        return this.H.get(row, col);
    }

    public Label getColLabel(int i2) {
        return this.M[i2];
    }

    public static class Label {
        public final LabelType type;
        public final int index;

        public Label(LabelType type, int index) {
            this.type = type;
            this.index = index;
        }

        public String toString() {
            StringBuilder a2 = new StringBuilder();
            Object[] objectArray = new Object[2];
            objectArray[0] = this.type.toString();
            objectArray[1] = this.index;
            a2.append(String.format(b.C("4c>41"), objectArray));
            return a2.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LabelType
    extends Enum<LabelType> {
        public static final /* enum */ LabelType VARIABLE = new LabelType();
        public static final /* enum */ LabelType COST;
        private static final /* synthetic */ LabelType[] $VALUES;
        public static final /* enum */ LabelType UNDEFINED;
        public static final /* enum */ LabelType CONSTRAINT;
        public static final /* enum */ LabelType B;

        public static LabelType[] values() {
            return (LabelType[])$VALUES.clone();
        }

        public static LabelType valueOf(String name) {
            return Enum.valueOf(LabelType.class, name);
        }

        static {
            B = new LabelType();
            CONSTRAINT = new LabelType();
            COST = new LabelType();
            UNDEFINED = new LabelType();
            LabelType[] labelTypeArray = new LabelType[5];
            labelTypeArray[0] = VARIABLE;
            labelTypeArray[1] = B;
            labelTypeArray[2] = CONSTRAINT;
            labelTypeArray[3] = COST;
            labelTypeArray[4] = UNDEFINED;
            $VALUES = labelTypeArray;
        }

        private LabelType() {
            LabelType a2;
        }
    }
}

