/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.pivoting;

import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.problem.LpProblem;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.Tableau;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.pivoting.SimplexPivoting;

public class NaiveRule
implements SimplexPivoting {
    public int pricing(Tableau table) {
        int a2;
        int a3 = table.nCols() - 1;
        int a4 = 0;
        int n = a2 = 1;
        while (n <= a3) {
            if (table.getColLabel((int)a2).type == Tableau.LabelType.VARIABLE && DoubleUtils.compare(table.getCostRow(a2), 0.0, table.epsilon) < 0) {
                a4 = table.getCostRow(a2) < (a4 > 0 ? table.getCostRow(a4) : Double.POSITIVE_INFINITY) ? a2 : a4;
            }
            n = ++a2;
        }
        return a4;
    }

    public int ratioTest(Tableau table, int s) {
        int a2;
        int a3 = table.nRows() - 1;
        int a4 = table.nCols() - 1;
        int a5 = 0;
        double a6 = Double.MAX_VALUE;
        int n = a2 = 1;
        while (n <= a3) {
            double a7 = table.get(a2, s);
            if (DoubleUtils.compare(a7, 0.0, table.epsilon) < 0) {
                double a8 = -table.get(a2, a4 + 1) / a7;
                if (a8 < a6 - table.epsilon || DoubleUtils.compare(a8, a6, table.epsilon) == 0 && table.getRowLabel((int)a2).index < table.getRowLabel((int)a5).index) {
                    a6 = a8;
                    a5 = a2;
                }
            }
            n = ++a2;
        }
        return a5;
    }

    public SimplexPivoting.Pivot findPivot(Tableau table) throws LpProblem.Unbounded {
        int a2 = this.pricing(table);
        if (a2 == 0) {
            return null;
        }
        int a3 = this.ratioTest(table, a2);
        if (a3 == 0) {
            throw new LpProblem.Unbounded(a2);
        }
        return new SimplexPivoting.Pivot(a3, a2);
    }
}

