/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.standard;

import com.numericalmethod.suanshu.matrix.doubles.AreMatrices;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.LpSolution;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.LpSolver;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.Tableau;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.pivoting.SmallestSubscriptRule;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import java.util.HashSet;
import java.util.Set;

public class LpBoundedSolution
implements LpSolution {
    private final Tableau m;
    private Set<MyImmutableVector> H = new HashSet<MyImmutableVector>();

    public LpBoundedSolution(LpSolver phase2) {
        SuanShuUtils.assertArgument(phase2.lambdaCol() == 0, null);
        this.m = phase2.getResultantTableau();
        this.H.add(new MyImmutableVector(this.m.minimizer()));
        SuanShuUtils.assertArgument(1 + this.H(this.m) == this.H.size(), b.C("}{t{~fzghpq`8ytsm6"));
    }

    public ImmutableVector minimizer() {
        return this.H.toArray(new ImmutableVector[0])[0];
    }

    public ImmutableVector[] minimizers() {
        return this.H.toArray(new ImmutableVector[0]);
    }

    private int H(Tableau a2) {
        int a3;
        int a4 = 0;
        int n = a3 = 1;
        while (n < a2.nCols()) {
            LpBoundedSolution a5;
            if (DoubleUtils.compare(a2.getCostRow(a3), 0.0, a5.m.epsilon) == 0) {
                MyImmutableVector a6;
                Tableau a7 = new Tableau(a2);
                int a8 = new SmallestSubscriptRule().ratioTest(a7, a3);
                a7.swap(a8, a3);
                if (a7.isFeasible() && !a5.H.contains(a6 = a5.new MyImmutableVector(a7.minimizer()))) {
                    a5.H.add(a6);
                    ++a4;
                    a4 += a5.H(a7);
                }
            }
            n = ++a3;
        }
        return a4;
    }

    public double min() {
        return this.m.min();
    }

    private class MyImmutableVector
    extends ImmutableVector {
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Vector)) {
                return false;
            }
            Vector a2 = (Vector)obj;
            if (!AreMatrices.equal(this, a2, ((LpBoundedSolution)LpBoundedSolution.this).m.epsilon)) {
                return false;
            }
            return true;
        }

        MyImmutableVector(Vector a2) {
            MyImmutableVector a3;
            super(a2);
        }

        public int hashCode() {
            return 7;
        }
    }
}

