/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.standard;

import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.LpSolution;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.LpSolver;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.Tableau;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class LpUnboundedSolution
implements LpSolution {
    private final Tableau m;
    private int H = 0;

    public ImmutableVector minimizer() {
        return this.m.minimizer();
    }

    public double min() {
        return Double.NEGATIVE_INFINITY;
    }

    public LpUnboundedSolution(LpSolver phase2) {
        this.H = phase2.lambdaCol();
        SuanShuUtils.assertArgument(this.H > 0, null);
        this.m = phase2.getResultantTableau();
    }

    public ImmutableVector v() {
        int a2;
        int a3 = this.m.nRows() - 1;
        DenseVector a4 = new DenseVector(this.m.problemSize(), 0.0);
        a4.set(this.m.getColLabel((int)this.H).index, 1.0);
        int n = a2 = 1;
        while (n <= a3) {
            if (this.m.getRowLabel((int)a2).type == Tableau.LabelType.VARIABLE) {
                a4.set(this.m.getRowLabel((int)a2).index, this.m.get(a2, this.H));
            }
            n = ++a2;
        }
        return new ImmutableVector(a4);
    }
}

