/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.standard;

import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.LpSolution;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.LpSolver;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.problem.LpProblem;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.Tableau;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.pivoting.SimplexPivoting;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.pivoting.SmallestSubscriptRule;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.standard.LpBoundedSolution;
import com.numericalmethod.suanshu.optimization.constrained.linearprogramming.simplex.standard.LpUnboundedSolution;

public class Phase2ByFerrisMangasarianWright
implements LpSolver {
    private Tableau M;
    private SimplexPivoting m;
    private LpProblem.Unbounded H = null;

    public Phase2ByFerrisMangasarianWright(Tableau table, SimplexPivoting pivoting) {
        this.M = new Tableau(table);
        this.m = pivoting;
    }

    public LpSolution solve() throws LpProblem.Infeasible {
        Object a2;
        try {
            a2 = this.m.findPivot(this.M);
            while (a2 != null) {
                if (!this.M.isFeasible()) {
                    throw new LpProblem.Infeasible();
                }
                this.M.swap(((SimplexPivoting.Pivot)a2).r, ((SimplexPivoting.Pivot)a2).s);
                a2 = this.m.findPivot(this.M);
            }
        }
        catch (LpProblem.Unbounded a3) {
            this.H = a3;
            return new LpUnboundedSolution(this);
        }
        a2 = new LpBoundedSolution(this);
        return a2;
    }

    public Tableau getResultantTableau() {
        return new Tableau(this.M);
    }

    public Phase2ByFerrisMangasarianWright(Tableau table) {
        this(table, new SmallestSubscriptRule());
    }

    public boolean isUnbounded() {
        return this.lambdaCol() > 0;
    }

    public int lambdaCol() {
        return this.H == null ? 0 : this.H.s;
    }
}

