/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedMinimizer;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedProblem;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class NelderMead
implements UnconstrainedMinimizer {
    private int G;
    public final double alpha;
    private int M;
    public final double rho;
    private double m = Double.POSITIVE_INFINITY;
    public final double sigma;
    private RealScalarFunction H;
    public final double gamma;

    public double minimum() {
        return this.m;
    }

    public void solve(UnconstrainedProblem problem, double tol) {
        this.solve(problem.f, tol);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Vector[] H(Vector ... a2) {
        int a3;
        int a4;
        int a5;
        int a6;
        NelderMead a7;
        double[] a8 = new double[a7.M];
        int n = a6 = 0;
        while (n < a7.M) {
            a8[a6] = a7.H.evaluate(a2[a6].toArray());
            n = ++a6;
        }
        int[] a22 = R.order(a8);
        Vector[] a9 = new Vector[a7.M];
        int n2 = a5 = 0;
        while (n2 < a7.M) {
            a9[a5] = a2[a22[a5] - 1];
            n2 = ++a5;
        }
        Arrays.sort(a8);
        Vector a32 = new DenseVector(a7.G);
        int n3 = a4 = 0;
        while (n3 < a7.G) {
            a32 = a32.add(a9[a4]);
            n3 = ++a4;
        }
        a32 = a32.scaled(1.0 / (double)a7.G);
        Vector a42 = a32.add(a32.minus(a9[a7.G]).scaled(a7.alpha));
        double a10 = a7.H.evaluate(a42.toArray());
        if (a8[0] <= a10) {
            if (a10 < a8[a7.G - 1]) {
                a9[a7.G] = a42;
                return a9;
            }
        }
        if (a10 < a8[0]) {
            double d2;
            Vector a11 = a32.add(a32.minus(a9[a7.G]).scaled(a7.gamma));
            double a12 = a7.H.evaluate(a11.toArray());
            if (d2 < a10) {
                a9[a7.G] = a11;
                return a9;
            }
            a9[a7.G] = a42;
            return a9;
        }
        Vector a13 = a10 < a8[a7.G] ? a32.add(a42.minus(a32).scaled(a7.rho)) : a32.add(a9[a7.G].minus(a32).scaled(a7.rho));
        double a14 = a7.H.evaluate(a13.toArray());
        if (a10 < a8[a7.G] && a14 <= a10 || a10 >= a8[a7.G] - 1.0E-14 && a14 < a8[a7.G]) {
            a9[a7.G] = a13;
            return a9;
        }
        int n4 = a3 = 1;
        while (n4 < a7.G + 1) {
            a9[a3] = a9[0].add(a9[a3].minus(a9[0]).scaled(a7.sigma));
            n4 = ++a3;
        }
        return a9;
    }

    public Vector search(int maxIterations, Vector initial, BuildSimplex simplex) {
        Vector[] a2 = simplex.build(initial);
        return this.search(maxIterations, a2);
    }

    public NelderMead(double alpha, double gamma, double rho, double sigma) {
        this.alpha = alpha;
        this.gamma = gamma;
        this.rho = rho;
        this.sigma = sigma;
    }

    public Vector search(int maxIterations, Vector ... simplex) {
        int a2;
        int a3;
        int a4;
        if (simplex.length != this.M) {
            return this.search(maxIterations, simplex[0], new DefaultSimplex());
        }
        int n = a4 = 0;
        while (n < simplex.length) {
            SuanShuUtils.assertArgument(simplex[a4].size() == this.G, b.C("a|s5u}\u007fpsgwzw4us%l&qnqq5c{z5du~v]4B}T4VpZf[p\u0019{\\5CfCpE{O5Br\u000e3"));
            n = ++a4;
        }
        Vector[] a22 = simplex;
        int n2 = a3 = 0;
        while (n2 < maxIterations) {
            a22 = this.H(a22);
            n2 = ++a3;
        }
        Vector a32 = a22[0];
        int n3 = a2 = 0;
        while (n3 < this.M) {
            double d2;
            double a5 = this.H.evaluate(a22[a2].toArray());
            if (d2 < this.m) {
                a32 = a22[a2];
                this.m = a5;
            }
            n3 = ++a2;
        }
        return a32;
    }

    public NelderMead() {
        this(1.0, 2.0, 0.5, 0.5);
    }

    public double[] search(double[] initial) {
        return this.search(500, initial);
    }

    public void solve(RealScalarFunction f, double tol) {
        this.H = f;
        this.G = f.dimension4Domain();
        this.M = this.G + 1;
    }

    public double[] search(int maxIterations, double[] initial) {
        Vector[] vectorArray = new Vector[1];
        vectorArray[0] = new DenseVector(initial);
        return this.search(maxIterations, vectorArray).toArray();
    }

    public double[] search(int maxIterations, double[] ... simplex) {
        int a2;
        int a3 = simplex.length;
        Vector[] a4 = new Vector[a3];
        int n = a2 = 0;
        while (n < a3) {
            a4[a2] = new DenseVector(simplex[a2]);
            n = ++a2;
        }
        Vector a22 = this.search(maxIterations, a4);
        return a22.toArray();
    }

    private static class DefaultSimplex
    implements BuildSimplex {
        private DefaultSimplex() {
            DefaultSimplex a2;
        }

        public Vector[] build(Vector initial) {
            int a2;
            int a3;
            double a4 = 0.0;
            int n = a3 = 1;
            while (n <= initial.size()) {
                if (a4 < Math.abs(initial.get(a3))) {
                    a4 = Math.abs(initial.get(a3));
                }
                n = ++a3;
            }
            a4 = a4 == 0.0 ? 1.0 : 0.1 * a4;
            Vector[] vectorArray = new Vector[initial.size() + 1];
            Vector[] a22 = vectorArray;
            vectorArray[0] = initial.deepCopy();
            int n2 = a2 = 1;
            while (n2 <= initial.size()) {
                a22[a2] = initial.deepCopy();
                a22[a2].set(a2, a22[a2].get(a2) + a4);
                n2 = ++a2;
            }
            return a22;
        }
    }

    public static interface BuildSimplex {
        public Vector[] build(Vector var1);
    }
}

