/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.optimization.unconstrained.NelderMead;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedMinimizer;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class UnconstrainedMaximizer {
    private final UnconstrainedMinimizer H;

    public UnconstrainedMaximizer(UnconstrainedMinimizer minimizer) {
        this.H = minimizer;
    }

    public UnconstrainedMaximizer() {
        this(new NelderMead());
    }

    public double[] search(int maxIterations, double ... initials) {
        Vector[] vectorArray = new Vector[1];
        vectorArray[0] = new DenseVector(initials);
        return this.H.search(maxIterations, vectorArray).toArray();
    }

    public Vector search(int maxIterations, Vector ... initials) {
        return this.H.search(maxIterations, initials);
    }

    public void solve(final RealScalarFunction f, double tol) {
        RealScalarFunction a2 = new RealScalarFunction(){
            {
                1 a2;
            }

            public double evaluate(double ... x2) {
                return -1.0 * f.evaluate(x2);
            }

            public int dimension4Range() {
                return f.dimension4Range();
            }

            public int dimension4Domain() {
                return f.dimension4Domain();
            }
        };
        this.H.solve(a2, tol);
    }
}

