/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.conjugatedirection;

import com.numericalmethod.suanshu.analysis.differentiation.multivariate.GradientFunction;
import com.numericalmethod.suanshu.analysis.differentiation.multivariate.HessianFunction;
import com.numericalmethod.suanshu.analysis.function.matrix.RntoMatrix;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.MatrixMathImpl;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent.SteepestDescent;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class ConjugateGradient
extends SteepestDescent {
    private RntoMatrix H;

    protected SteepestDescent.LineSearch getLineSearch() {
        return new HestenesStiefel(this.H);
    }

    public void solve(RealScalarFunction f, RealVectorFunction g2, RntoMatrix H, double tol) {
        this.H = H;
        super.solve(f, g2, tol);
    }

    public void solve(RealScalarFunction f, RealVectorFunction g2, double tol) {
        this.solve(f, new GradientFunction(f), new HessianFunction(f), tol);
    }

    class HestenesStiefel
    extends SteepestDescent.LineSearch {
        private int H;

        protected void reset() {
            this.H = 0;
            super.reset();
        }

        HestenesStiefel(RntoMatrix a2) {
            HestenesStiefel a3;
            super(a2);
            a3.H = 0;
        }

        void direction(Vector a2) {
            HestenesStiefel a3;
            ++a3.H;
            Vector a4 = a3.ConjugateGradient.this.g.evaluate(a2.toArray());
            Vector a5 = a4.scaled(-1.0);
            if (a3.H > 1) {
                double a6 = a4.innerProduct(a4);
                Vector a7 = a3.dk.scaled(a6 /= a3.gk.innerProduct(a3.gk));
                a5 = a5.add(a7);
            }
            a3.gk = a4;
            a3.dk = a5;
        }

        public double minimize(Vector xk) {
            this.direction(xk);
            double a2 = this.gk.innerProduct(this.gk);
            this.Hk = this.H.evaluate(xk.toArray());
            DenseMatrix a3 = new DenseMatrix(this.dk);
            double a4 = ((MatrixMathImpl)a3.t()).multiply(this.Hk).multiply(a3).get(1, 1);
            double a5 = a2 / a4;
            return a5;
        }
    }
}

