/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.conjugatedirection;

import com.numericalmethod.suanshu.optimization.unconstrained.linesearch.Fletcher;
import com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent.SteepestDescent;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class Powell
extends SteepestDescent {
    protected SteepestDescent.LineSearch getLineSearch() {
        return new PowellImpl();
    }

    class PowellImpl
    extends SteepestDescent.LineSearch {
        public final Fletcher linesearch;
        public final int n;
        private int m;
        private Vector[] H;

        public double minimize(Vector xk) {
            Vector a2 = this.H(xk);
            double a3 = this.H(a2, this.dk);
            return a3 += 1.0;
        }

        protected void reset() {
            this.m = 0;
            super.reset();
        }

        private Vector H(Vector a2) {
            int a3;
            PowellImpl a4;
            ++a4.m;
            Vector a5 = a2;
            if (a4.m == 1) {
                int n = a3 = 1;
                while (n <= a4.n) {
                    a4.H[a3] = new DenseVector(a4.n);
                    a4.H[a3].set(a3, a2.get(a3));
                    n = ++a3;
                }
            } else {
                int n = a3 = 1;
                while (true) {
                    if (n > a4.n - 1) break;
                    a4.H[a3] = a4.H[a3 + 1];
                    n = ++a3;
                }
                a4.H[a4.n] = a4.dk;
            }
            int n = a3 = 1;
            while (n <= a4.n) {
                double a6 = a4.H(a5, a4.H[a3]);
                a5 = a5.add(a4.H[a3].scaled(a6));
                n = ++a3;
            }
            a4.dk = a5.minus(a2);
            return a5;
        }

        PowellImpl() {
            PowellImpl a2;
            super(null);
            a2.linesearch = new Fletcher(a2.Powell.this.f, a2.Powell.this.g);
            a2.n = a2.Powell.this.f.dimension4Domain();
            a2.m = 0;
            a2.H = new Vector[a2.n + 1];
        }

        private double H(Vector a2, Vector a3) {
            double a4;
            PowellImpl a5;
            double a6 = a5.linesearch.search(a2, a3);
            if (a6 >= (a4 = a5.linesearch.search(a2, a3.scaled(-1.0)))) {
                return a6;
            }
            return -a4;
        }
    }
}

