/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.conjugatedirection;

import com.numericalmethod.suanshu.Constant;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.optimization.unconstrained.linesearch.Fletcher;
import com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent.SteepestDescent;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class Zangwill
extends SteepestDescent {
    private double H;

    public void solve(RealScalarFunction f, RealVectorFunction g2, double tol, double tol2) {
        this.H = tol2;
        super.solve(f, g2, tol);
    }

    protected SteepestDescent.LineSearch getLineSearch() {
        return new ZangwillImpl(this.H);
    }

    public void solve(RealScalarFunction f, RealVectorFunction g2, double tol) {
        this.solve(f, g2, tol, Constant.EPSILON);
    }

    class ZangwillImpl
    extends SteepestDescent.LineSearch {
        public final int n;
        private double F;
        public final double threshold2;
        private int B;
        private double G;
        private double M;
        private Vector[] m;
        private int H;
        public final Fletcher linesearch;

        protected void reset() {
            this.B = 0;
            super.reset();
        }

        ZangwillImpl(double a2) {
            ZangwillImpl a3;
            super(null);
            a3.linesearch = new Fletcher(a3.Zangwill.this.f, a3.Zangwill.this.g);
            a3.n = a3.Zangwill.this.f.dimension4Domain();
            a3.B = 0;
            a3.m = new Vector[a3.n + 1];
            a3.H = Integer.MIN_VALUE;
            a3.F = Double.NaN;
            a3.M = Double.NaN;
            a3.G = 1.0;
            a3.threshold2 = a2;
        }

        private double H(Vector a2, Vector a3) {
            double a4;
            ZangwillImpl a5;
            double a6 = a5.linesearch.search(a2, a3);
            if (a6 >= (a4 = a5.linesearch.search(a2, a3.scaled(-1.0)))) {
                return a6;
            }
            return -a4;
        }

        private Vector H(Vector a2) {
            int a3;
            ZangwillImpl a4;
            ++a4.B;
            Vector a5 = a2;
            if (a4.B == 1) {
                int n = a3 = 1;
                while (n <= a4.n) {
                    a4.m[a3] = new DenseVector(a4.n);
                    a4.m[a3].set(a3, 1.0);
                    n = ++a3;
                }
            } else {
                double d2;
                double a6 = a4.F * a4.G / a4.M;
                if (d2 > a4.threshold2) {
                    a4.m[a4.H] = a4.dk;
                    a4.G = a6;
                }
            }
            a4.F = Double.NEGATIVE_INFINITY;
            int n = a3 = 1;
            while (n <= a4.n) {
                double a7 = a4.H(a5, a4.m[a3]);
                a5 = a5.add(a4.m[a3].scaled(a7));
                if (a7 > a4.F) {
                    a4.H = a3;
                    a4.F = a7;
                }
                n = ++a3;
            }
            a4.dk = a5.minus(a2);
            a4.M = a4.dk.norm();
            return a5;
        }

        public double minimize(Vector xk) {
            Vector a2 = this.H(xk);
            double a3 = this.H(a2, this.dk);
            return a3 += 1.0;
        }
    }
}

