/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.hessian;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class GoldfeldQuandtTrotter
extends DenseMatrix {
    public GoldfeldQuandtTrotter(Matrix H, double beta) {
        super(H.nCols(), H.nRows());
        SuanShuUtils.assertArgument(beta > 0.0, b.C("wqbt1*2e"));
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(H), b.C("E,cxzx*o`,g-r}wloi>`xxhd-"));
        Matrix a2 = H.ONE();
        if (beta != Double.POSITIVE_INFINITY) {
            a2 = H.add(H.ONE().scaled(beta)).scaled(1.0 / (1.0 + beta));
        }
        this.overwrite(a2);
    }
}

