/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.hessian;

import com.numericalmethod.suanshu.matrix.DimensionCheck;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.factorization.triangle.LDL;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;

public class MatthewsDavies
extends DenseMatrix {
    private final LowerTriangularMatrix G;
    private final DiagonalMatrix M;
    private final DiagonalMatrix m;
    private final UpperTriangularMatrix H;

    public MatthewsDavies(Matrix H) {
        super(H.nCols(), H.nRows());
        int a2;
        SuanShuUtils.assertArgument(DimensionCheck.isSquare(H), b.C("E,cxzx*o`,g-r}wloi>`xxhd-"));
        double a3 = SuanShuUtils.autoEpsilon(H);
        LDL a4 = new LDL(H);
        this.G = a4.L();
        this.H = a4.Lt();
        this.m = a4.D();
        this.M = new DiagonalMatrix(this.m);
        double a5 = 1.0;
        int n = a2 = 1;
        while (n <= this.M.nRows()) {
            double d2;
            double a6 = this.M.get(a2, a2);
            if (d2 > a3 && a6 < a5) {
                a5 = a6;
            }
            n = ++a2;
        }
        int n2 = a2 = 1;
        while (n2 <= this.M.nRows()) {
            if (this.M.get(a2, a2) <= a3) {
                this.M.set(a2, a2, a5);
            }
            n2 = ++a2;
        }
        Matrix a22 = this.G.multiply(this.M).multiply(this.H);
        this.overwrite(a22);
    }

    public DiagonalMatrix Dhat() {
        return new DiagonalMatrix(this.M);
    }

    public LowerTriangularMatrix L() {
        return new LowerTriangularMatrix(this.G);
    }

    public DiagonalMatrix D() {
        return new DiagonalMatrix(this.m);
    }

    public UpperTriangularMatrix Lt() {
        return this.G.t();
    }
}

