/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.linesearch;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class Fletcher {
    public final double rho;
    RealScalarFunction f;
    public final double sigma;
    public final double tau;
    RealVectorFunction gradient;
    public final int maxIterations;
    public final double tol;
    public final double chi;

    public Fletcher(double rho, double sigma, double tau, double chi, RealScalarFunction f, RealVectorFunction gradient, double tol, int maxIterations) {
        SuanShuUtils.assertArgument(f.dimension4Domain() == gradient.dimension4Domain(), b.C("_\u0018[WY\u0018YKP\\[\\[L\u0016QHNO\u0019YPK\u0019RYO\\\u0005\\ITxQt\u0019yQs\\\u007fK{V;"));
        this.rho = rho;
        this.sigma = sigma;
        this.tau = tau;
        this.chi = chi;
        this.f = f;
        this.gradient = gradient;
        this.tol = tol;
        this.maxIterations = maxIterations;
    }

    public double search(final Vector x2, final Vector d2) {
        int a2;
        UnivariateRealFunction a3 = new UnivariateRealFunction(){
            {
                1 a2;
            }

            public double evaluate(double a2) {
                Vector a3 = x2.add(d2.scaled(a2));
                return Fletcher.this.f.evaluate(a3.toArray());
            }
        };
        UnivariateRealFunction a4 = new UnivariateRealFunction(){
            {
                2 a2;
            }

            public double evaluate(double a2) {
                Vector a3 = x2.add(d2.scaled(a2));
                double a4 = Fletcher.this.gradient.evaluate(a3.toArray()).innerProduct(d2);
                return a4;
            }
        };
        double a5 = 0.0;
        double a6 = 1.0E99;
        double a7 = a3.evaluate(a5);
        double a8 = a4.evaluate(a5);
        double a9 = 1.0;
        if (Math.abs(a8) > 0.0) {
            a9 = -2.0 * a7 / a8;
        }
        if (a9 <= this.tol || a9 > 1.0) {
            a9 = 1.0;
        }
        int n = a2 = 1;
        int n2 = this.maxIterations;
        while (n <= n2) {
            double a10;
            double a11;
            double d3;
            double a12 = a3.evaluate(a9);
            if (d3 > a7 + this.rho * (a9 - a5) * a8 && Math.abs(a7 - a12) > this.tol) {
                if (a9 < a6) {
                    a6 = a9;
                }
                if ((a11 = a5 + Math.pow(a9 - a5, 2.0) * a8 / 2.0 / (a7 - a12 + (a9 - a5) * a8)) < (a10 = a5 + this.tau * (a6 - a5))) {
                    a11 = a10;
                }
                if (a11 > (a10 = a6 - this.tau * (a6 - a5))) {
                    a11 = a10;
                }
                a9 = a11;
            } else {
                double a13;
                double d4;
                double d5;
                a11 = a4.evaluate(a9);
                if (!(d5 < this.sigma * a8) || !(Math.abs(a7 - a12) > this.tol) || DoubleUtils.equal(a11, a8, this.tol)) break;
                a10 = (a9 - a5) * a11 / (a8 - a11);
                if (d4 <= 0.0) {
                    a10 = a9;
                }
                if (a10 < (a13 = this.tau * (a9 - a5))) {
                    a10 = a13;
                }
                if (a10 > (a13 = this.chi * (a6 - a9))) {
                    a10 = a13;
                }
                double a14 = a9 + a10;
                a5 = a9;
                a9 = a14;
                a7 = a12;
                a8 = a11;
            }
            n = ++a2;
            n2 = this.maxIterations;
        }
        if (a9 < 1.0E-5) {
            a9 = 1.0E-5;
        }
        return a9;
    }

    public Fletcher(RealScalarFunction f, RealVectorFunction gradient) {
        this(0.1, 0.1, 0.1, 0.75, f, gradient, 1.0E-10, 400);
    }
}

