/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.quasinewton;

import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.optimization.unconstrained.quasinewton.QuasiNewton;
import com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent.SteepestDescent;

public class BFGS
extends QuasiNewton {
    private final double m = 0.0;
    private boolean H;

    protected SteepestDescent.LineSearch getLineSearch() {
        return new BFGSImpl();
    }

    public void solve(boolean isFletcherSwitch, RealScalarFunction f, RealVectorFunction g2, double tol) {
        this.H = isFletcherSwitch;
        super.solve(f, g2, tol);
    }

    private class BFGSImpl
    extends QuasiNewton.QuasiNewtonImpl {
        void updateSk(Matrix a2) {
            BFGSImpl a3;
            DenseMatrix a4 = new DenseMatrix(a3.dk.scaled(a3.ak));
            Matrix a5 = a2.t().multiply(a3.Sk);
            double a6 = a2.t().multiply(a4).get(1, 1);
            double a7 = (1.0 + a5.multiply(a2).get(1, 1) / a6) / a6;
            Matrix a8 = a4.multiply(a4.t());
            Matrix a9 = a8.scaled(a7);
            Matrix a10 = a4.multiply(a5);
            Matrix a11 = a3.Sk.multiply(a2).multiply(a4.t());
            Matrix a12 = a10.add(a11).scaled(-1.0 / a6);
            Matrix a13 = a3.Sk.add(a9).add(a12);
            if (a3.BFGS.this.H) {
                Matrix a14 = a2.t().multiply(a13).multiply(a2);
                double a15 = a14.get(1, 1);
                if (a6 - a15 > 0.0) {
                    Matrix a16 = a8.scaled(1.0 / a6);
                    Matrix a17 = a3.Sk.multiply(a2);
                    Matrix a18 = a17.multiply(a17.t());
                    Matrix a19 = a5.multiply(a2);
                    double a20 = a19.get(1, 1);
                    Matrix a21 = a18.scaled(-1.0 / a20);
                    a13 = a13.add(a16).add(a21);
                }
            }
            a3.Sk = a13;
        }

        private BFGSImpl() {
            BFGSImpl a2;
        }
    }
}

