/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.quasinewton;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.optimization.unconstrained.quasinewton.QuasiNewton;
import com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent.SteepestDescent;

public class Huang
extends QuasiNewton {
    public final double psi;
    public final double phi;
    public final double theta;
    public final double omega;

    public Huang(double theta, double phi, double psi, double omega) {
        this.theta = theta;
        this.phi = phi;
        this.psi = psi;
        this.omega = omega;
    }

    protected SteepestDescent.LineSearch getLineSearch() {
        return new HuangImpl();
    }

    private class HuangImpl
    extends QuasiNewton.QuasiNewtonImpl {
        private HuangImpl() {
            HuangImpl a2;
        }

        void updateSk(Matrix a2) {
            Matrix a3;
            HuangImpl a4;
            DenseMatrix a5 = new DenseMatrix(a4.dk.scaled(a4.ak));
            Matrix a6 = a4.Sk.t().multiply(a2);
            Matrix a7 = a5.scaled(a4.Huang.this.theta).add(a6.scaled(a4.Huang.this.phi)).t();
            Matrix a8 = a5.multiply(a7);
            double a9 = a7.multiply(a2).get(1, 1);
            Matrix a10 = a5.scaled(a4.Huang.this.psi).add(a6.scaled(a4.Huang.this.omega)).t();
            Matrix a11 = a4.Sk.multiply(a2).multiply(a10);
            Matrix a12 = a10.multiply(a2);
            double a13 = a12.get(1, 1);
            a4.Sk = a3 = a4.Sk.add(a8.scaled(1.0 / a9)).minus(a11.scaled(1.0 / a13));
        }
    }
}

