/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.quasinewton;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.optimization.unconstrained.linesearch.Fletcher;
import com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent.SteepestDescent;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public abstract class QuasiNewton
extends SteepestDescent {

    public abstract class QuasiNewtonImpl
    extends SteepestDescent.LineSearch {
        public final Fletcher linesearch;
        private int H;
        protected double ak;
        protected Matrix Sk;
        public final int n;

        public QuasiNewtonImpl() {
            super(null);
            this.linesearch = new Fletcher(0.1, 0.7, 0.1, 0.75, QuasiNewton.this.f, QuasiNewton.this.g, 1.0E-10, 600);
            this.n = QuasiNewton.this.f.dimension4Domain();
            this.Sk = new DenseMatrix(this.n, this.n).ONE();
            this.ak = Double.NaN;
            this.H = 0;
        }

        protected void reset() {
            super.reset();
            this.Sk = new DenseMatrix(this.n, this.n).ONE();
            this.ak = Double.NaN;
            this.H = 0;
        }

        abstract void updateSk(Matrix var1);

        public double minimize(Vector xk) {
            ++this.H;
            Vector a2 = this.gk;
            this.gk = QuasiNewton.this.g.evaluate(xk.toArray());
            if (this.H >= 2) {
                Vector vector;
                Vector a3 = this.gk.minus(a2);
                if (vector.norm() < QuasiNewton.this.tol) {
                    return 1.0E-5;
                }
                DenseMatrix a4 = new DenseMatrix(a3);
                this.updateSk(a4);
            }
            this.dk = this.Sk.multiply(this.gk).scaled(-1.0);
            this.ak = this.linesearch.search(xk, this.dk);
            return this.ak;
        }
    }
}

