/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent;

import com.numericalmethod.suanshu.optimization.unconstrained.linesearch.Fletcher;
import com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent.SteepestDescent;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class FirstOrder
extends SteepestDescent {
    private final Method H;

    public FirstOrder(Method method) {
        this.H = method;
    }

    protected SteepestDescent.LineSearch getLineSearch() {
        GradientDescent a2;
        switch (this.H) {
            case ANALYTIC: {
                do {
                } while (false);
                a2 = new Analytic();
                break;
            }
            default: {
                a2 = new InexactLineSearch();
            }
        }
        return a2;
    }

    public FirstOrder() {
        this(Method.IN_EXACT_LINE_SEARCH);
    }

    private class Analytic
    extends GradientDescent {
        private double H;

        private Analytic() {
            Analytic a2;
            a2.H = 1.0;
        }

        protected void reset() {
            this.H = 1.0;
        }

        public double minimize(Vector xk) {
            double a2;
            this.direction(xk);
            Vector a3 = xk.minus(this.gk.scaled(this.H));
            double a4 = FirstOrder.this.f.evaluate(a3.toArray());
            double a5 = FirstOrder.this.f.evaluate(xk.toArray());
            double a6 = this.gk.innerProduct(this.gk);
            this.H = a2 = a6 * this.H * this.H / 2.0 / (a4 - a5 + this.H * a6);
            return a2;
        }
    }

    private class InexactLineSearch
    extends GradientDescent {
        private final Fletcher H;

        public double minimize(Vector xk) {
            this.direction(xk);
            return this.H.search(xk, this.dk);
        }

        private InexactLineSearch() {
            InexactLineSearch a2;
            a2.H = new Fletcher(a2.FirstOrder.this.f, a2.FirstOrder.this.g);
        }
    }

    private abstract class GradientDescent
    extends SteepestDescent.LineSearch {
        private GradientDescent() {
            GradientDescent a2;
            super(null);
        }

        void direction(Vector a2) {
            GradientDescent a3;
            a3.gk = a3.FirstOrder.this.g.evaluate(a2.toArray());
            a3.dk = a3.gk.scaled(-1.0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method ANALYTIC;
        public static final /* enum */ Method IN_EXACT_LINE_SEARCH;
        private static final /* synthetic */ Method[] $VALUES;

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String name) {
            return Enum.valueOf(Method.class, name);
        }

        static {
            IN_EXACT_LINE_SEARCH = new Method();
            ANALYTIC = new Method();
            Method[] methodArray = new Method[2];
            methodArray[0] = IN_EXACT_LINE_SEARCH;
            methodArray[1] = ANALYTIC;
            $VALUES = methodArray;
        }

        private Method() {
            Method a2;
        }
    }
}

