/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent;

import com.numericalmethod.suanshu.analysis.differentiation.multivariate.JacobianFunction;
import com.numericalmethod.suanshu.analysis.function.matrix.RntoMatrix;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2rm.RealVectorFunction;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.optimization.unconstrained.UnconstrainedProblem;
import com.numericalmethod.suanshu.optimization.unconstrained.hessian.MatthewsDavies;
import com.numericalmethod.suanshu.optimization.unconstrained.linesearch.Fletcher;
import com.numericalmethod.suanshu.optimization.unconstrained.steepestdescent.SteepestDescent;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class GaussNewton
extends SteepestDescent {
    private RntoMatrix m;
    private RealVectorFunction H;

    protected SteepestDescent.LineSearch getLineSearch() {
        return new GaussNewtonImpl(this.H, this.m);
    }

    public void solve(UnconstrainedProblem problem, double tol) {
        throw new UnsupportedOperationException(b.C("a|\u007ff1w~tng>qvqi5k{r5rarebfz5\\ziz[gBgP}\\pYDLz[x_8"));
    }

    private static RealScalarFunction H(final RealVectorFunction a2) {
        return new RealScalarFunction(){

            public double evaluate(double ... x2) {
                Vector a22 = a2.evaluate(x2);
                return a22.innerProduct(a22);
            }

            public int dimension4Range() {
                return 1;
            }
            {
                2 a22;
            }

            public int dimension4Domain() {
                return a2.dimension4Domain();
            }
        };
    }

    public void solve(RealVectorFunction vf, RntoMatrix J, double tol) {
        this.H = vf;
        this.m = J;
        super.solve(GaussNewton.H(vf), GaussNewton.H(vf, J), tol);
    }

    public void solve(RealVectorFunction vf, double tol) {
        this.solve(vf, new JacobianFunction(vf), tol);
    }

    private static RealVectorFunction H(final RealVectorFunction a2, final RntoMatrix a3) {
        return new RealVectorFunction(){

            public int dimension4Domain() {
                return a2.dimension4Domain();
            }
            {
                1 a22;
            }

            public int dimension4Range() {
                return a2.dimension4Domain();
            }

            public Vector evaluate(double ... x2) {
                Matrix a22 = a3.evaluate(x2).t();
                DenseMatrix a32 = new DenseMatrix(a2.evaluate(x2));
                Matrix a4 = a22.multiply(a32).scaled(2.0);
                return new DenseVector(MatrixUtils.to1DArray(a4));
            }
        };
    }

    private class GaussNewtonImpl
    extends SteepestDescent.LineSearch {
        public final RntoMatrix J;
        public final RealScalarFunction F;
        public final RealVectorFunction vf;
        private final Fletcher m;
        private Matrix H;

        private GaussNewtonImpl(RealVectorFunction a2, RntoMatrix a3) {
            GaussNewtonImpl a4;
            super(null);
            a4.vf = a2;
            a4.F = GaussNewton.H(a2);
            a4.J = a3;
            a4.m = new Fletcher(a4.F, a4.GaussNewton.this.g);
        }

        public double minimize(Vector xk) {
            this.H = this.J.evaluate(xk.toArray());
            this.gk = GaussNewton.this.g.evaluate(xk.toArray());
            this.Hk = this.H.t().multiply(this.H).scaled(2.0);
            MatthewsDavies a2 = new MatthewsDavies(this.Hk);
            this.dk = new Inverse((Matrix)a2).multiply(this.gk).scaled(-1.0);
            return this.m.search(xk, this.dk);
        }
    }
}

